/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractAccessLogFilter<R, S>
implements InitializingBean {
    private static final Logger accessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    private static final Logger log = LoggerFactory.getLogger(AbstractAccessLogFilter.class);
    public static final String OW_HOST = "host";
    private static final String OW_PATH = "accesslog_overwrite_path";
    private static final String ModeBlack = "black";
    private static final String ModeWhite = "white";
    private static final String COLLECT_COOKIE_MAP_KEY = "_accesslog_collect_cookie_map";
    private static final String LOG_COOKIE_ATTRIBUTE_KEY = "_accesslog_log_cookie";
    private static final String EX_ATTRIBUTE_KEY = "_accesslog_ex";
    private static final String OVERWRITE_ATTRIBUTE_KEY = "_accesslog_overwrite";
    private static final String APP_ID_ATTRIBUTE_KEY = "_accesslog_app_id";
    private static final String CONSUMER_ID_ATTRIBUTE_KEY = "_accesslog_consumer_id";
    private static final String DONT_WRITE_CURRENT_ACCESSLOG = "dont_write_current_accesslog";
    private String mode = "black";
    private Set<String> inhosts = new HashSet<String>();
    private Set<String> blackPaths = new HashSet<String>();
    private Set<String> blackUriPatterns = new HashSet<String>();
    private Map<String, String> cookieHosts = new ConcurrentHashMap<String, String>();
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public void afterPropertiesSet() {
        try {
            Properties p = new Properties();
            ClassPathResource res = new ClassPathResource("/accesslog_filter.properties");
            if (!res.exists()) {
                return;
            }
            p.load(res.getInputStream());
            if (!p.isEmpty()) {
                this.loadConfig(p);
                log.info("load accesslog_filter.properties success");
            }
        }
        catch (Exception e) {
            log.warn("load accesslog_filter.properties failed", (Throwable)e);
        }
    }

    private void loadConfig(Properties properties) {
        List<String> hosts;
        this.mode = properties.getProperty("accesslog.mode");
        String hoststring = properties.getProperty("accesslog.hosts");
        if (hoststring != null && !CollectionUtils.isEmpty(hosts = Arrays.asList(hoststring.trim().split(",")))) {
            this.inhosts = new HashSet<String>(hosts);
        }
        String blackpaths = properties.getProperty("accesslog.blackpaths");
        List<String> paths = Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)blackpaths), (String)","));
        for (String path : paths) {
            if (path != null && !path.contains("*")) {
                this.blackPaths.add(path);
                continue;
            }
            if (path == null || !path.contains("*")) continue;
            this.blackUriPatterns.add(path);
        }
    }

    private boolean needLog(R req) {
        Boolean val = (Boolean)this.getAttribute(req, DONT_WRITE_CURRENT_ACCESSLOG);
        if (val != null && val.booleanValue()) {
            return false;
        }
        String host = this.getHost(req);
        if (ModeBlack.equals(this.mode) ? this.inhosts.contains(host) : ModeWhite.equals(this.mode) && !this.inhosts.contains(host)) {
            return false;
        }
        String path = this.clearRequestURI(this.getPath(req));
        if (this.blackPaths.contains(path)) {
            return false;
        }
        for (String pattern : this.blackUriPatterns) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            return false;
        }
        return true;
    }

    private String getHost(R req) {
        String host;
        Map map = (Map)this.getAttribute(req, OVERWRITE_ATTRIBUTE_KEY);
        if (map != null && (host = (String)map.get(OW_HOST)) != null) {
            return host;
        }
        return this.getHeader(req, OW_HOST);
    }

    protected abstract String getRequestURI(R var1);

    protected abstract String getMethod(R var1);

    protected abstract String getQueryString(R var1);

    protected abstract String getHeader(R var1, String var2);

    protected abstract String getIpAddr(R var1);

    protected abstract boolean isPerfTestRequest(R var1);

    protected abstract void addAttribute(R var1, String var2, Object var3);

    protected abstract Object getAttribute(R var1, String var2);

    protected abstract String getParameter(R var1, String var2);

    protected abstract List<String> getParameterNames(R var1);

    protected abstract int getStatus(S var1);

    protected abstract void addCookie(S var1, String var2, String var3, String var4, String var5);

    protected void doBefore(R req, S resp) {
        HashMap<String, String> collCookie = new HashMap<String, String>();
        try {
            this.addCookieIfNeed(req, resp, collCookie);
            this.addAttribute(req, COLLECT_COOKIE_MAP_KEY, collCookie);
        }
        catch (Exception e) {
            log.error("addCookieIfNeed error");
        }
    }

    protected void doAfter(R req, S resp, long cost) {
        try {
            boolean isPerfUrl = this.isPerfTestRequest(req);
            if (!isPerfUrl && this.needLog(req)) {
                Map collCookie = (Map)this.getAttribute(req, COLLECT_COOKIE_MAP_KEY);
                this.processAccessLog(req, resp, cost, collCookie);
            }
        }
        catch (Exception e) {
            log.error("AccessLogFilter process error, message=", (Throwable)e);
        }
    }

    private void addCookieIfNeed(R req, S resp, Map<String, String> collCookie) {
        List<String> parameterNames = this.getParameterNames(req);
        String host = this.getHeader(req, OW_HOST);
        String cookieHost = this.getCookieHost(host);
        for (String key : parameterNames) {
            String verify;
            String[] v;
            if (!key.startsWith("tck_") || (v = key.split("_")).length != 3 || !(verify = SecurityUtils.encode2StringByMd5((String)v[1])).endsWith(v[2])) continue;
            String name = v[1];
            String value = this.getParameter(req, key);
            String cookiekey = "_coll_" + name;
            collCookie.put(cookiekey, value);
            try {
                this.addCookie(resp, cookiekey, value, cookieHost, "/");
            }
            catch (Exception e) {
                log.error("addCookie error,cookieKey=" + cookiekey + ",value=" + value, (Throwable)e);
            }
        }
    }

    private void processAccessLog(R req, S resp, long cost, Map<String, String> collCookie) throws Exception {
        String method = StringUtils.lowerCase((String)this.getMethod(req));
        if (!"get".equals(method) && !"post".equals(method)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url_host", this.getHost(req));
        map.put("url_path", this.clearRequestURI(this.getPath(req)));
        map.put("url_query", this.getQueryString(req));
        map.put("http_method", this.getMethod(req));
        map.put("rc", this.getStatus(resp));
        map.put("rt", cost);
        map.put("mip", NetUtils.getLocalIp());
        this.putIfNotNull(map, "ex", this.getExPair(req));
        String callback = this.getParameter(req, "callback");
        if (!StringUtils.isBlank((CharSequence)callback)) {
            map.put("http_method", "POST");
        }
        Map<String, String> cookieMap = this.getCookieMap(req);
        Long consumerId = this.getConsumerId(req);
        Long appId = this.getAppId(req);
        String ac = cookieMap.get("_ac");
        if (ac != null && (consumerId == null || appId == null)) {
            try {
                String json = new String(SecurityUtils.decodeBase64((String)ac), Charsets.UTF_8);
                if (json != null) {
                    JSONObject object = JSONObject.parseObject((String)json);
                    if (appId == null) {
                        appId = object.getLong("aid");
                    }
                    if (consumerId == null) {
                        consumerId = object.getLong("cid");
                    }
                }
            }
            catch (Exception e) {
                log.info("_ac decode fail , _ac= " + ac);
            }
        }
        this.putIfNotNull(map, "consumer_id", consumerId);
        this.putIfNotNull(map, "app_id", appId);
        this.handleCookies(cookieMap, collCookie);
        this.handleParams(req, collCookie);
        this.handleLogCookie(req, collCookie);
        this.putIfNotEmpty(map, "cookie", collCookie);
        this.putUa(req, map);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = this.getHeader(req, "referer");
        this.putIfNotNull(map, "referer", referer);
        String ip = this.getIpAddr(req);
        this.putIfNotNull(map, "ip", ip);
        accessLog.info(JSON.toJSONString(map));
    }

    private Map<String, Object> getExPair(R req) {
        return (Map)this.getAttribute(req, EX_ATTRIBUTE_KEY);
    }

    private void putUa(R req, Map<String, Object> map) {
        String ua = StringUtils.trimToEmpty((String)this.getHeader(req, "user-agent"));
        if (ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (!StringUtils.isEmpty((CharSequence)ua)) {
            map.put("user_agent", ua);
        }
    }

    private void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIfNotEmpty(Map<String, Object> map, String key, Map<String, String> collCookie) {
        if (!collCookie.isEmpty()) {
            map.put(key, collCookie);
        }
    }

    protected abstract Map<String, String> getCookieMap(R var1);

    private void handleCookies(Map<String, String> cookieMap, Map<String, String> collCookie) {
        for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
            String key = entry.getKey();
            String cookie = entry.getValue();
            if (!key.startsWith("_coll_")) continue;
            collCookie.put(key, cookie);
        }
    }

    private void handleParams(R req, Map<String, String> collCookie) {
        String deviceId;
        String slotId = this.getParameter(req, "adslotId");
        if (slotId != null) {
            collCookie.put("_coll_slot", slotId);
        }
        if ((deviceId = this.getParameter(req, "deviceId")) != null) {
            collCookie.put("_coll_device", deviceId);
        }
    }

    private void handleLogCookie(R req, Map<String, String> collCookie) {
        Map<String, String> logCookie = this.getLogCookie(req);
        if (logCookie != null) {
            for (Map.Entry<String, String> entry : logCookie.entrySet()) {
                collCookie.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, String> getLogCookie(R req) {
        return (Map)this.getAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY);
    }

    private String clearRequestURI(String requestURI) {
        if (StringUtils.isBlank((CharSequence)requestURI)) {
            return requestURI;
        }
        return StringUtils.replace((String)requestURI, (String)"//", (String)"/");
    }

    private String getCookieHost(String host) {
        String cookieHost;
        if (host == null) {
            return null;
        }
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(58));
        }
        if ((cookieHost = this.cookieHosts.get(host)) != null) {
            return cookieHost;
        }
        String hostLow = host.toLowerCase();
        if (hostLow.endsWith(".duiba.com.cn")) {
            cookieHost = "duiba.com.cn";
        } else if (hostLow.endsWith(".dui88.com")) {
            cookieHost = "dui88.com";
        } else if (hostLow.endsWith(".duibar.com")) {
            cookieHost = "duibar.com";
        } else if (hostLow.endsWith(".tuia.cn")) {
            cookieHost = "tuia.cn";
        }
        if (cookieHost != null) {
            this.cookieHosts.put(host, cookieHost);
        }
        return cookieHost;
    }

    public void setAppId(R req, Long appId) {
        this.ensureSafeCall();
        this.addAttribute(req, APP_ID_ATTRIBUTE_KEY, appId);
    }

    public void setConsumerId(R req, Long consumerId) {
        this.ensureSafeCall();
        this.addAttribute(req, CONSUMER_ID_ATTRIBUTE_KEY, consumerId);
    }

    private Long getAppId(R req) {
        Long appId = (Long)this.getAttribute(req, APP_ID_ATTRIBUTE_KEY);
        return appId;
    }

    private Long getConsumerId(R req) {
        Long consumerId = (Long)this.getAttribute(req, CONSUMER_ID_ATTRIBUTE_KEY);
        return consumerId;
    }

    public void putLogCookie(R req, String key, String value) {
        this.ensureSafeCall();
        HashMap<String, String> map = (HashMap<String, String>)this.getAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, String>();
            this.addAttribute(req, LOG_COOKIE_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void putExPair(R req, String key, Object value) {
        this.ensureSafeCall();
        HashMap<String, Object> map = (HashMap<String, Object>)this.getAttribute(req, EX_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.addAttribute(req, EX_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void putOverWritePair(R req, String key, String value) {
        this.ensureSafeCall();
        HashMap<String, String> map = (HashMap<String, String>)this.getAttribute(req, OVERWRITE_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, String>();
            this.addAttribute(req, OVERWRITE_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    public void dontWriteCurrentLog(R req) {
        this.addAttribute(req, DONT_WRITE_CURRENT_ACCESSLOG, true);
    }

    private String getPath(R req) {
        String path = (String)this.getAttribute(req, OW_PATH);
        if (StringUtils.isBlank((CharSequence)path)) {
            path = this.getRequestURI(req);
        }
        return path;
    }

    public void setOverWritePath(R req, String path) {
        this.addAttribute(req, OW_PATH, path);
    }

    protected abstract void ensureSafeCall();
}

