/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.hadoop.hbase.client.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.framework.ProxyFactory;

@Aspect
public class CatSpringDataHbaseAspect {
    private static final String space = "Hbase";

    @Around(value="execution(* org.apache.hadoop.hbase.client.HTableInterfaceFactory.createHTableInterface(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Table htable = (Table)joinPoint.proceed();
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)htable);
        factory.addAdvice((Advice)new HbaseMethodInterceptor());
        return factory.getProxy();
    }

    private static class HbaseMethodInterceptor
    implements MethodInterceptor {
        HbaseMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
                return invocation.proceed();
            }
            if (methodName.equals("exists") || methodName.equals("existsAll") || methodName.equals("batch") || methodName.equals("batchCallback") || methodName.equals("get") || methodName.equals("getScanner") || methodName.equals("put") || methodName.equals("checkAndPut") || methodName.equals("delete") || methodName.equals("checkAndDelete") || methodName.equals("mutateRow") || methodName.equals("append") || methodName.equals("increment") || methodName.equals("incrementColumnValue")) {
                return CatUtils.executeInCatTransaction(() -> invocation.proceed(), CatSpringDataHbaseAspect.space, methodName);
            }
            return invocation.proceed();
        }
    }
}

