/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import zipkin2.Endpoint;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class SleuthMybatisPlugin
implements Interceptor {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String[] strArr = mappedStatement.getId().split("\\.");
        String classAndMethod = strArr[strArr.length - 2] + "." + strArr[strArr.length - 1];
        Span span = this.tracer.nextSpan().name("sql:/" + classAndMethod).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("MySQL").build()).start();
        try {
            SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
            String method = sqlCommandType.name().toLowerCase();
            span.tag("sql.method", method);
            span.tag("sql.class_method", classAndMethod);
            span.tag("lc", "mybatis");
            result = invocation.proceed();
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
        return result;
    }

    public String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (!parameterMappings.isEmpty() && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", this.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }
}

