/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import zipkin2.Endpoint;

@Aspect
public class SleuthRedisPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Span span = this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start();
        try {
            span.tag("redis.op", methodName);
            span.tag("lc", "redisClient");
            if ("get".equals(methodName) && joinPoint.getArgs() != null && joinPoint.getArgs().length == 1 && joinPoint.getArgs()[0] != null) {
                span.tag("redis.key", joinPoint.getArgs()[0].toString());
            }
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

