/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix.CustomHystrixConcurrencyStrategy;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix.HystrixStreamEndpointPostProcessor;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@ConditionalOnClass(value={Hystrix.class})
public class HystrixAutoConfiguration {
    @Bean
    public HystrixConcurrencyStrategy getHystrixConcurrencyStrategy() {
        return new CustomHystrixConcurrencyStrategy();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> hystrixInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                Set<String> enabledFeignClientNames;
                if ((event.getApplicationContext() instanceof WebApplicationContext || event.getApplicationContext() instanceof ReactiveWebApplicationContext) && !(enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames()).isEmpty()) {
                    String anyfeignClientName = "bootInit";
                    HystrixCommand<String> command = new HystrixCommand<String>(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)anyfeignClientName)).andCommandKey(HystrixCommandKey.Factory.asKey((String)"bootInit"))){

                        protected String run() throws Exception {
                            return null;
                        }
                    };
                    command.execute();
                }
            }
        };
    }

    @Bean
    public static HystrixStreamEndpointPostProcessor hystrixStreamEndpointPostProcessor() {
        return new HystrixStreamEndpointPostProcessor();
    }
}

