/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordResultBuilder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordTraceWriter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordCustomizeFlowReplaySpanPlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordExcludeHandlerInterceptor;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordRedisTemplatePlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordRemoteServicePlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordRocketMqProducerPlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordSpringMvcFilter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordResultMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordStopMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.PercentageBasedRecordSampler;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayResultBuilder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceLoader;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResultWriter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop.ReplayCustomizeFlowReplaySpanPlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop.ReplayRedisTemplatePlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop.ReplayRocketMqProducerPlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop.ReplaySpringMvcFilter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayResultMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayStopMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ConcreateReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.RemoteServiceReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.SpringMvcReplayer;
import cn.com.duibaboot.ext.autoconfigure.security.BaseSecurityManager;
import com.google.common.collect.Lists;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.http.client.HttpClient;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Lazy
@Configuration
public class FlowReplayAutoConfiguration {
    @Bean
    public FlowReplayFileComponent flowReplayFileComponent(HttpClient httpClient, List<RestTemplateCustomizer> customizers) {
        RestTemplate loadBalancedRestTemplate = this.loadBalancedRestTemplate(httpClient);
        for (RestTemplateCustomizer customizer : customizers) {
            customizer.customize(loadBalancedRestTemplate);
        }
        return new FlowReplayFileComponent(loadBalancedRestTemplate);
    }

    private RestTemplate loadBalancedRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(60000);
        httpRequestFactory.setHttpClient(httpClient);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        return template;
    }

    private static class ReplayCondition
    implements Condition {
        private ReplayCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return FlowReplayUtils.isReplayEnv();
        }
    }

    @Configuration
    @Conditional(value={ReplayCondition.class})
    static class ReplayConfiguration {
        ReplayConfiguration() {
        }

        @Bean
        public ReplayCustomizeFlowReplaySpanPlugin replayCustomizeFlowReplaySpanPlugin() {
            return new ReplayCustomizeFlowReplaySpanPlugin();
        }

        @Bean
        public ReplayMvcEndpoint replayMvcEndpoint() {
            return new ReplayMvcEndpoint();
        }

        @Bean
        public ReplayStopMvcEndpoint replayStopMvcEndpoint() {
            return new ReplayStopMvcEndpoint();
        }

        @Bean
        public ReplayResultMvcEndpoint replayResultMvcEndpoint() {
            return new ReplayResultMvcEndpoint();
        }

        @Bean
        public ReplayTraceLoader replayTraceLoader() {
            return new ReplayTraceLoader();
        }

        @Bean
        public ReplayTraceReplayer replayTraceReplayer() {
            return new ReplayTraceReplayer();
        }

        @Bean
        public ReplayTraceResultWriter replayTraceResultWriter() {
            return new ReplayTraceResultWriter();
        }

        @Bean
        public ReplayResultBuilder replayResultBuilder() {
            return new ReplayResultBuilder();
        }

        @Bean
        public DuibaSecurityManagerConfiguar4ReplayApplicationListener duibaSecurityManagerConfiguar4ReplayApplicationListener() {
            return new DuibaSecurityManagerConfiguar4ReplayApplicationListener();
        }

        static class DuibaSecurityManagerConfiguar4ReplayApplicationListener
        implements ApplicationListener<ContextRefreshedEvent>,
        Ordered {
            private static final Logger log = LoggerFactory.getLogger(DuibaSecurityManagerConfiguar4ReplayApplicationListener.class);
            private boolean flag = true;

            DuibaSecurityManagerConfiguar4ReplayApplicationListener() {
            }

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (!this.flag) {
                    return;
                }
                try {
                    System.setSecurityManager(new BaseSecurityManager(){

                        @Override
                        public void checkExec(String cmd) {
                        }

                        @Override
                        public void checkPermission(Permission perm) {
                            if ("setSecurityManager".equals(perm.getName())) {
                                super.checkPermission(perm);
                            }
                        }

                        @Override
                        public void checkAccept(String host, int port) {
                            if (ReplayContextHolder.canHostPass(host)) {
                                return;
                            }
                            throw new SecurityException("Not allowed to accept to host:" + host + ",port:" + port);
                        }

                        @Override
                        public void checkConnect(String host, int port) {
                            if (ReplayContextHolder.canHostPass(host)) {
                                return;
                            }
                            throw new SecurityException("Not allowed to connect to host:" + host + ",port:" + port);
                        }

                        @Override
                        public void checkConnect(String host, int port, Object context) {
                            this.checkConnect(host, port);
                        }
                    });
                }
                catch (Throwable e) {
                    log.error("\u8bbe\u7f6eSercurityManager\u5931\u8d25\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u56de\u653e\u65f6\u4ecd\u7136\u80fd\u8bbf\u95ee\u7f51\u7edc\uff0c\u53ef\u80fd\u4f1a\u6c61\u67d3\u6570\u636e\u5e93\u6570\u636e\uff0c\u9000\u51fa\u5f53\u524d\u5e94\u7528", e);
                    System.exit(-1);
                }
                this.flag = false;
            }

            public int getOrder() {
                return -11;
            }
        }

        @Configuration
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        class ReplaySpringMvcConfiguration {
            ReplaySpringMvcConfiguration() {
            }

            @Bean
            public ReplaySpringMvcFilter replaySpringMvcFilter() {
                return new ReplaySpringMvcFilter();
            }

            @Bean
            public FilterRegistrationBean replaySpringMvcFilterConfigurer(ReplaySpringMvcFilter replaySpringMvcFilter) {
                FilterRegistrationBean registrationBean = new FilterRegistrationBean();
                registrationBean.setFilter((Filter)replaySpringMvcFilter);
                ArrayList urlPatterns = Lists.newArrayList();
                urlPatterns.add("/*");
                registrationBean.setUrlPatterns((Collection)urlPatterns);
                registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
                registrationBean.setOrder(0);
                return registrationBean;
            }
        }

        @Configuration
        static class ReplayerConfiguration {
            ReplayerConfiguration() {
            }

            @Bean
            public RemoteServiceReplayer remoteServiceReplayer() {
                return new RemoteServiceReplayer();
            }

            @Bean
            public SpringMvcReplayer springMvcReplayer() {
                return new SpringMvcReplayer();
            }

            @Bean
            public Replayer replayer() {
                return new ConcreateReplayer();
            }
        }

        @Configuration
        @ConditionalOnBean(value={RedisTemplate.class})
        protected static class ReplayRedisTemplatePluginConfiguration {
            protected ReplayRedisTemplatePluginConfiguration() {
            }

            @Bean
            public ReplayRedisTemplatePlugin replayRedisTemplatePlugin() {
                return new ReplayRedisTemplatePlugin();
            }
        }

        @Configuration
        @ConditionalOnClass(value={DefaultMQProducer.class})
        protected static class ReplayRocketMqProducerPluginConfiguration {
            protected ReplayRocketMqProducerPluginConfiguration() {
            }

            @Bean
            public ReplayRocketMqProducerPlugin replayRocketMqProducerPlugin() {
                return new ReplayRocketMqProducerPlugin();
            }
        }
    }

    @Configuration
    static class RecordConfiguration {
        RecordConfiguration() {
        }

        @Bean
        public RecordCustomizeFlowReplaySpanPlugin recordCustomizeFlowReplaySpanPlugin() {
            return new RecordCustomizeFlowReplaySpanPlugin();
        }

        @Bean
        public RecordMvcEndpoint recordMvcEndpoint() {
            return new RecordMvcEndpoint();
        }

        @Bean
        public RecordStopMvcEndpoint recordStopMvcEndpoint() {
            return new RecordStopMvcEndpoint();
        }

        @Bean
        public RecordResultMvcEndpoint recordResultMvcEndpoint() {
            return new RecordResultMvcEndpoint();
        }

        @Bean
        public RecordResultBuilder recordResultBuilder() {
            return new RecordResultBuilder();
        }

        @Bean
        public RecordTraceWriter recordTraceWriter() {
            return new RecordTraceWriter();
        }

        @Bean
        @ConditionalOnMissingBean
        public PercentageBasedRecordSampler recordSampler() {
            return new PercentageBasedRecordSampler();
        }

        @Configuration
        static class FlowRecordAspectConfiguration {
            FlowRecordAspectConfiguration() {
            }

            @Bean
            public RecordRemoteServicePlugin recordRemoteServicePlugin() {
                return new RecordRemoteServicePlugin();
            }
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class, RecordExcludeHandlerInterceptor.class, InterceptorRegistry.class})
        @ConditionalOnWebApplication
        @Order(value=-100)
        public static class RecordExcludeHandlerInterceptorConfiguration
        extends WebMvcConfigurerAdapter {
            public void addInterceptors(InterceptorRegistry registry) {
                RecordExcludeHandlerInterceptor interceptor = new RecordExcludeHandlerInterceptor();
                registry.addInterceptor((HandlerInterceptor)interceptor);
                super.addInterceptors(registry);
            }
        }

        @Configuration
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        class RecordSpringMvcConfiguration {
            RecordSpringMvcConfiguration() {
            }

            @Bean
            public RecordSpringMvcFilter recordSpringMvcFilter() {
                return new RecordSpringMvcFilter();
            }

            @Bean
            public FilterRegistrationBean recordSpringMvcFilterConfigurer(RecordSpringMvcFilter recordSpringMvcFilter) {
                FilterRegistrationBean registrationBean = new FilterRegistrationBean();
                registrationBean.setFilter((Filter)recordSpringMvcFilter);
                ArrayList urlPatterns = Lists.newArrayList();
                urlPatterns.add("/*");
                registrationBean.setUrlPatterns((Collection)urlPatterns);
                registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
                registrationBean.setOrder(0);
                return registrationBean;
            }
        }

        @Configuration
        @ConditionalOnBean(value={RedisTemplate.class})
        protected static class RecordRedisTemplatePluginConfiguration {
            protected RecordRedisTemplatePluginConfiguration() {
            }

            @Bean
            public RecordRedisTemplatePlugin recordRedisTemplatePlugin() {
                return new RecordRedisTemplatePlugin();
            }
        }

        @Configuration
        @ConditionalOnClass(value={DefaultMQProducer.class})
        protected static class RecordRocketMqProducerPluginConfiguration {
            protected RecordRocketMqProducerPluginConfiguration() {
            }

            @Bean
            public RecordRocketMqProducerPlugin recordRocketMqProducerPlugin() {
                return new RecordRocketMqProducerPlugin();
            }
        }
    }
}

