/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FlowReplayFileComponent {
    private static final Logger log = LoggerFactory.getLogger(FlowReplayFileComponent.class);
    private final RestTemplate loadBalancedRestTemplate;

    public FlowReplayFileComponent(RestTemplate loadBalancedRestTemplate) {
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
    }

    public String upload(String localPath) throws IOException {
        String localZipFileName = "/data/flowreplay/" + System.currentTimeMillis() + ".zip";
        File localFile = new File(localPath);
        File localZipFile = new File(localZipFileName);
        byte[] buffer = new byte[1024];
        try (FileInputStream is = new FileInputStream(localFile);
             BufferedInputStream bis = new BufferedInputStream(is);
             FileOutputStream os = new FileOutputStream(localZipFile);
             ZipOutputStream zipos = new ZipOutputStream(os);){
            zipos.putNextEntry(new ZipEntry(localFile.getName()));
            int i = bis.read(buffer);
            while (i != -1) {
                zipos.write(buffer, 0, i);
                i = bis.read(buffer);
            }
        }
        FileSystemResource resource = new FileSystemResource(localZipFile);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"file", (Object)resource);
        String ossPath = (String)this.loadBalancedRestTemplate.postForObject("http://athena-web/athena/file/upload", (Object)multiValueMap, String.class, new Object[0]);
        FlowReplayFileComponent.initDir();
        return ossPath;
    }

    public String download(String ossPath) throws IOException {
        FlowReplayFileComponent.initDir();
        ResponseEntity response = this.loadBalancedRestTemplate.getForEntity("http://athena-web/athena/file/download?objectName=" + ossPath, Resource.class, new Object[0]);
        InputStream input = ((Resource)response.getBody()).getInputStream();
        String newFilePath = "/data/flowreplay/flow_replay";
        try (ZipInputStream zipInputStream = new ZipInputStream(input);
             FileOutputStream fileOutputStream = new FileOutputStream(newFilePath);){
            int len;
            zipInputStream.getNextEntry();
            byte[] buf = new byte[1024];
            while ((len = zipInputStream.read(buf, 0, 1024)) != -1) {
                fileOutputStream.write(buf, 0, len);
            }
        }
        return newFilePath;
    }

    public static void initDir() {
        File dir = new File("/data/flowreplay/");
        try {
            FileUtils.deleteDirectory((File)dir);
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            log.error("\u521d\u59cb\u5316/data/flowreplay\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }
}

