/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.mybatis;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.mybatis.SpringBootVFS;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MybatisAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, VFS.class})
    public static class MyBatisBugfixPostProcessorConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor mybatisBugfixPostProcessorConfigurer() {
            boolean hasVfsMethod = false;
            try {
                SqlSessionFactoryBean.class.getMethod("getVfs", new Class[0]);
                hasVfsMethod = true;
            }
            catch (NoSuchMethodException e) {
                logger.warn("method[org.mybatis.spring.SqlSessionFactoryBean.getVfs()] is not exist, \u65e0\u6cd5\u81ea\u52a8\u4fee\u590dmybatis\u7684bug\uff0c\u8bf7\u5347\u7ea7mybatis-spring\u52301.3.1\u6216\u4ee5\u4e0a\u7248\u672c(\u5426\u5219cat\u6709\u53ef\u80fd\u65e0\u6cd5\u5bf9sql\u8fdb\u884c\u76d1\u63a7)");
            }
            final boolean hasVfsMethodFinal = hasVfsMethod;
            return new SpecifiedBeanPostProcessor<SqlSessionFactoryBean>(){

                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<SqlSessionFactoryBean> getBeanType() {
                    return SqlSessionFactoryBean.class;
                }

                @Override
                public Object postProcessBeforeInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                    if (hasVfsMethodFinal && bean.getVfs() == null) {
                        bean.setVfs(SpringBootVFS.class);
                    }
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(SqlSessionFactoryBean bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }
    }
}

