/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;

@Configuration
@ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
@ConditionalOnClass(value={TransmittableThreadLocal.class, WebSocketHandlerMapping.class, WebSocketMessageBrokerConfigurer.class})
public class WebSocketPerfTestConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebSocketPerfTestConfiguration.class);

    @Bean
    public static SpecifiedBeanPostProcessor<WebSocketHandlerMapping> webSocketHandlerMappingSpecifiedBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<WebSocketHandlerMapping>(){

            @Override
            public Class<WebSocketHandlerMapping> getBeanType() {
                return WebSocketHandlerMapping.class;
            }

            @Override
            public Object postProcessBeforeInitialization(WebSocketHandlerMapping bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(WebSocketHandlerMapping bean, String beanName) throws BeansException {
                for (Object rh : bean.getUrlMap().values()) {
                    if (rh instanceof SockJsHttpRequestHandler) {
                        SockJsHttpRequestHandler rh1 = (SockJsHttpRequestHandler)rh;
                        ((TransportHandlingSockJsService)rh1.getSockJsService()).getHandshakeInterceptors().add(0, new HandshakeInterceptor(){

                            public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
                                if (request instanceof ServletServerHttpRequest) {
                                    this.setPerfTestAttributes((ServletServerHttpRequest)request, attributes);
                                }
                                return true;
                            }

                            public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
                            }
                        });
                        continue;
                    }
                    log.warn("\u6682\u65f6\u4e0d\u652f\u6301\u5bf9\u6b64websocket\u5904\u7406\u7c7b\uff1a\u3010{}\u3011\u7684\u538b\u6d4b, \u8bf7\u4f7f\u7528sockjs", (Object)rh.getClass().toString());
                }
                return bean;
            }

            private void setPerfTestAttributes(ServletServerHttpRequest request, Map<String, Object> attributes) {
                ServletServerHttpRequest req = request;
                if (PerfTestUtils.isPerfTestRequest((HttpServletRequest)req.getServletRequest())) {
                    attributes.put("_duibaPerf", true);
                    String sceneId = PerfTestUtils.getPerfTestSceneId((HttpServletRequest)req.getServletRequest());
                    boolean isTestCluster = PerfTestUtils.isPerfTestCluster((HttpServletRequest)req.getServletRequest());
                    if (StringUtils.isNotBlank((CharSequence)sceneId)) {
                        attributes.put("_duibaPerfSceneId", sceneId);
                        attributes.put("_duibaPerfTestCluster", String.valueOf(isTestCluster));
                    }
                }
            }

            public int getOrder() {
                return 0;
            }
        };
    }

    @Bean
    public WebSocketMessageBrokerConfigurer bootWebSocketMessageBrokerConfigurer() {
        return new WebSocketMessageBrokerConfigurer(){

            public void registerStompEndpoints(StompEndpointRegistry registry) {
            }

            public void configureClientInboundChannel(ChannelRegistration registration) {
                registration.interceptors(new ChannelInterceptor[]{new ExecutorChannelInterceptor(){

                    public Message<?> preSend(Message<?> message, MessageChannel channel) {
                        return message;
                    }

                    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
                    }

                    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
                    }

                    public boolean preReceive(MessageChannel channel) {
                        return true;
                    }

                    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
                        return message;
                    }

                    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
                    }

                    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
                        Map sessionAttr = (Map)message.getHeaders().get((Object)"simpSessionAttributes");
                        if (sessionAttr != null && Boolean.TRUE.equals(sessionAttr.get("_duibaPerf"))) {
                            String perfTestSceneId = (String)sessionAttr.get("_duibaPerfSceneId");
                            boolean isTestCluster = Boolean.valueOf((String)sessionAttr.get("_duibaPerfTestCluster"));
                            InternalPerfTestContext.markAsPerfTest((String)perfTestSceneId, (boolean)isTestCluster);
                        }
                        return message;
                    }

                    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
                        InternalPerfTestContext.markAsNormal();
                    }
                }});
            }
        };
    }
}

