/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class FeatureReactiveFilter
implements WebFilter {
    private Mono<Void> enableFeature(ServerWebExchange exchange, boolean isEnable) {
        if (!ReactiveHttpRequestUtils.isLocalRequest(exchange.getRequest())) {
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
        }
        String type = (String)exchange.getRequest().getQueryParams().getFirst((Object)"type");
        if (StringUtils.isBlank((String)type)) {
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "ERROR");
        }
        if (type.equals("cat") && CatUtils.isCatClassExists()) {
            if (isEnable) {
                CatInstance.enable();
            } else {
                CatInstance.disable();
            }
        } else {
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "ERROR");
        }
        return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestPath = exchange.getRequest().getPath().pathWithinApplication().value();
        if (requestPath.equals("/_disableFeature")) {
            return this.enableFeature(exchange, false);
        }
        if (requestPath.equals("/_enableFeature")) {
            return this.enableFeature(exchange, true);
        }
        return chain.filter(exchange);
    }
}

