package cn.com.duibaboot.ext.autoconfigure;

import cn.com.duibaboot.ext.autoconfigure.javaagent.PluginAgent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import net.bytebuddy.agent.ByteBuddyAgent;

public final class DuibaBootVersion {
    private DuibaBootVersion() {
    }

    /**
     * Return the full version string of the present Spring Boot codebase, or {@code null}
     * if it cannot be determined.
     * @return the version of Spring Boot or {@code null}
     * @see Package#getImplementationVersion()
     */
    public static String getVersion() {
        Package pkg = DuibaBootVersion.class.getPackage();
        return (pkg != null ? pkg.getImplementationVersion() : null);
    }

    public static void main(String[] args) {
        PluginAgent.agentmain(null, ByteBuddyAgent.install());
        Cache cache = CacheBuilder.newBuilder().build();
    }
}
