package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * 修改字节码，修复elasticjob与spring-cloud不兼容的问题，elasticjob过早调用了feign，报出超时问题，这里尝试延迟到容器启动完成后再执行任务
 */
public class ElasticJobInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler";
    private static final String METHOD_INTERCET_CLASS = ElasticJobMethodInterceptor.class.getName();

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
                new InstanceMethodsInterceptPoint() {
                    @Override
                    public ElementMatcher<MethodDescription> getMethodsMatcher() {
                        return named("prepareEnvironments");
                    }

                    @Override
                    public String getMethodsInterceptor() {
                        return METHOD_INTERCET_CLASS;
                    }

                    @Override public boolean isOverrideArgs() {
                        return false;
                    }
                }
        };
    }

    @Override
    protected ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }
}
