package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 构造录制结果，并且把录制结果回填到 RecordContext 中
 * Created by guoyanfei .
 * 2019-02-25 .
 */
@Slf4j
public class RecordResultBuilder {

    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    /**
     * 监听"录制结束"事件
     * @param event
     * @throws IOException
     */
    @EventListener(RecordEndEvent.class)
    public void recordEndEventListener(RecordEndEvent event) {
        new Thread(new Runnable() {

            @Override
            public void run() {
                RecordContext context = RecordContextHolder.getRecordContext();
                if (context == null) {
                    return;
                }
                String ossPath = null;
                try {
                    ossPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RECORD_FILEPATH);
                } catch (IOException e) {
                    log.error("录制文件上传异常", e);
                }

                RecordResult result = new RecordResult(context.getUsecaseSetId(), event.isNormal(), event.getMessage(), ossPath, context.getCurrentFileSize(), context.getStartTime(), context.getEndTime());
                context.setRecordResult(result);
            }
        }, "DBThread-Record-Upload").start();

    }
}
