package cn.com.duibaboot.ext.autoconfigure.security;


import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

class SecurityCheckSandbox {

    private final List<DefensivePolicy> policyList;
    private HttpServletRequest request;
    private HttpServletResponse response;

    SecurityCheckSandbox(HttpServletRequest request, HttpServletResponse response,List<DefensivePolicy> policyList){
        this.policyList = policyList;
        this.request = request;
        this.response = response;
    }

    void doCheck() {
        if(policyList==null||policyList.isEmpty()){
            return;
        }
        for(DefensivePolicy policy:policyList){
            this.request = policy.preprocessorRequest(this.request);
            this.response = policy.preprocessorResponse(this.response);

            policy.doDefensive(this.request,this.response);
        }
    }

    void doFilter(FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(request,response);
    }


}
