/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.DefaultTransaction;
import org.springframework.core.Ordered;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CatReactiveWebFilter
implements WebFilter,
Ordered {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!CatUtils.isCatEnabled()) {
            return chain.filter(exchange);
        }
        if ("true".equals(exchange.getRequest().getHeaders().getFirst("X-Rpc"))) {
            return chain.filter(exchange);
        }
        long startTime = System.nanoTime();
        return chain.filter(exchange).then(Mono.fromRunnable(() -> this.recordInCatTransaction(exchange, startTime, null))).doOnError(throwable -> this.recordInCatTransaction(exchange, startTime, (Throwable)throwable)).then();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordInCatTransaction(ServerWebExchange exchange, long catStartTime, Throwable throwable) {
        String path = (String)exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (path == null) {
            path = exchange.getRequest().getURI().getPath();
        }
        DefaultTransaction webUrlTransaction = (DefaultTransaction)Cat.newTransaction((String)"URL", (String)path);
        webUrlTransaction.setDurationStart(catStartTime);
        try {
            Throwable exToLog = throwable;
            if (exToLog == null) {
                webUrlTransaction.setStatus("0");
            } else {
                webUrlTransaction.setStatus(exToLog);
                Cat.logError((Throwable)exToLog);
            }
        }
        finally {
            webUrlTransaction.complete();
        }
    }

    public int getOrder() {
        return -100;
    }
}

