/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.cat.CatWithArgs;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultTransaction;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnClass(value={Servlet.class, FeignClient.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class CatRpcHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CatRpcHandlerInterceptor.class);
    @Value(value="${spring.application.name}")
    private String springApplicationName;
    private static final String RPC_CAT_CONTEXT_KEY = "RpcCatContext";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod) || RequestUtils.getRequestPath((HttpServletRequest)request).equals("/error") && request.getAttribute("javax.servlet.forward.request_uri") != null) {
            return true;
        }
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Class<?> handlerClass = method.getDeclaringClass();
        if (handlerClass.equals(BasicErrorController.class)) {
            return true;
        }
        Class<?> feignClientClass = null;
        for (Class<?> clazz : handlerClass.getInterfaces()) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class) && !clazz.isAnnotationPresent(FeignClient.class)) continue;
            feignClientClass = clazz;
            break;
        }
        if (feignClientClass == null) {
            logger.warn("[NOTIFYME]can not find any interface of class:[{}] which annotated with @FeignClient or @AdvancedFeignClient, will not report to cat", (Object)handlerClass.getName());
            return true;
        }
        if ((method = ReflectionUtils.findMethod(feignClientClass, (String)method.getName(), (Class[])method.getParameterTypes())) == null) {
            logger.warn("[NOTIFYME]feign method is null");
        }
        RpcContext.getContext().setMethod(method);
        String catRpcClientName = request.getHeader("X-Rpc-Client");
        String catRpcServerName = request.getHeader("X-Rpc-Server");
        RpcContext.getContext().setSourceServiceId(catRpcClientName);
        RpcContext.getContext().setTargetServiceId(catRpcServerName);
        if (!CatUtils.isCatEnabled()) {
            return true;
        }
        this.initRpcContext(request, method);
        String loggerName = feignClientClass.getSimpleName() + "." + (method == null ? "undefined" : method.getName());
        String type = "PigeonService";
        Transaction transaction = Cat.newTransaction((String)type, (String)loggerName);
        RpcCatContext context = this.initContext();
        context.setCurrentTransaction(transaction);
        context.setMethod(method);
        this.createProviderCross(request, transaction);
        Cat.logRemoteCallServer((Cat.Context)context);
        this.setAttachment(context);
        request.setAttribute(RPC_CAT_CONTEXT_KEY, (Object)context);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Exception ex1;
        RpcCatContext context = (RpcCatContext)request.getAttribute(RPC_CAT_CONTEXT_KEY);
        if (context == null) {
            return;
        }
        Transaction transaction = context.getCurrentTransaction();
        Method method = context.getMethod();
        if (method != null && method.isAnnotationPresent(CatWithArgs.class)) {
            DefaultTransaction dt = (DefaultTransaction)transaction;
            dt.setName(dt.getName() + this.resolveArgs(request, method));
        }
        if (ex == null && (ex1 = (Exception)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE)) != null && ex1 instanceof BizException) {
            ex = ex1;
        }
        if (ex != null) {
            if (ex instanceof BizException) {
                Event bizExceptionEvent = Cat.newEvent((String)"BizException", (String)String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", ex.getMessage(), ((BizException)ex).getCode()));
                this.completeEvent(bizExceptionEvent);
                transaction.addChild((Message)bizExceptionEvent);
                transaction.setStatus("0");
            } else {
                Cat.logError((Throwable)ex);
                transaction.setStatus((Throwable)ex);
            }
        } else {
            transaction.setStatus("0");
        }
        CatUtils.completeTransaction(transaction);
        RpcContext.removeContext();
    }

    private String resolveArgs(HttpServletRequest request, Method method) {
        List argList = (List)request.getAttribute("Http-Req-Attr-Rpc-Args");
        if (argList == null || argList.isEmpty()) {
            return "";
        }
        CatWithArgs catWithArgs = method.getAnnotation(CatWithArgs.class);
        int[] argIndexes = catWithArgs.argIndexes();
        if (argIndexes == null || argIndexes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int argIdx : argIndexes) {
            if (argIdx < 0 || argList.size() <= argIdx) continue;
            Object obj = argList.get(argIdx);
            sb.append(obj == null ? "" : obj.toString()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    private void initRpcContext(HttpServletRequest req, Method method) {
        String catRootId = req.getHeader("_catRootMessageId");
        String catParentId = req.getHeader("_catParentMessageId");
        String catChildId = req.getHeader("_catChildMessageId");
        String catRpcClientName = req.getHeader("X-Rpc-Client");
        RpcContext.getContext().setAttachment("_catRootMessageId", catRootId);
        RpcContext.getContext().setAttachment("_catParentMessageId", catParentId);
        RpcContext.getContext().setAttachment("_catChildMessageId", catChildId);
        RpcContext.getContext().setAttachment("X-Rpc-Client", catRpcClientName);
    }

    private void setAttachment(Cat.Context context) {
        RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
        RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
        RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
    }

    private RpcCatContext initContext() {
        RpcCatContext context = new RpcCatContext();
        Map<String, String> attachments = RpcContext.getContext().getAttachments();
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry<String, String> entry : attachments.entrySet()) {
                if (!"_catChildMessageId".equals(entry.getKey()) && !"_catRootMessageId".equals(entry.getKey()) && !"_catParentMessageId".equals(entry.getKey())) continue;
                context.addProperty(entry.getKey(), entry.getValue());
            }
        }
        return context;
    }

    private void completeEvent(Event event) {
        AbstractMessage message = (AbstractMessage)event;
        message.setStatus("0");
        message.setCompleted(true);
    }

    private void createProviderCross(HttpServletRequest request, Transaction transaction) {
        String consumerAppName = RpcContext.getContext().getAttachment("X-Rpc-Client");
        Event crossServerEvent = Cat.newEvent((String)"PigeonService.client", (String)consumerAppName);
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossServerEvent);
        Event serverEvent = Cat.newEvent((String)"PigeonService.server", (String)this.springApplicationName);
        this.completeEvent(serverEvent);
        transaction.addChild((Message)serverEvent);
    }

    static class RpcCatContext
    implements Cat.Context {
        private Transaction currentTransaction;
        private Method method;
        private Map<String, String> properties = new HashMap<String, String>();

        RpcCatContext() {
        }

        public void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public Transaction getCurrentTransaction() {
            return this.currentTransaction;
        }

        public void setCurrentTransaction(Transaction currentTransaction) {
            this.currentTransaction = currentTransaction;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }
}

