/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.DevRibbonServerListFilter;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0005\"\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcn/com/duibaboot/ext/autoconfigure/cloud/netflix/ribbon/DevRibbonServerListFilter;", "Lcn/com/duiba/boot/netflix/ribbon/RibbonServerListFilter;", "isRunInDevMode", "", "(Z)V", "()Z", "setRunInDevMode", "component1", "copy", "equals", "other", "", "filter", "", "Lcom/netflix/loadbalancer/Server;", "serverList", "key", "hashCode", "", "toString", "", "spring-boot-ext"})
public final class DevRibbonServerListFilter
implements RibbonServerListFilter {
    private boolean isRunInDevMode;

    @NotNull
    public List<Server> filter(@NotNull List<? extends Server> serverList, @Nullable Object key) {
        Intrinsics.checkParameterIsNotNull(serverList, (String)"serverList");
        if (!this.isRunInDevMode || !serverList.stream().allMatch(filter.1.INSTANCE)) {
            return serverList;
        }
        List retList = new ArrayList();
        for (Server server : serverList) {
            if (!(server instanceof DiscoveryEnabledServer)) continue;
            InstanceInfo instanceInfo = ((DiscoveryEnabledServer)server).getInstanceInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)instanceInfo, (String)"server.instanceInfo");
            if (!instanceInfo.getIPAddr().equals(NetUtils.getLocalIp())) continue;
            retList.add(server);
        }
        if (retList.isEmpty()) {
            for (Server server : serverList) {
                if (!(server instanceof DiscoveryEnabledServer)) continue;
                InstanceInfo instanceInfo = ((DiscoveryEnabledServer)server).getInstanceInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)instanceInfo, (String)"server.instanceInfo");
                if ("false".equals(instanceInfo.getMetadata().get("runInSingleJarMode"))) continue;
                retList.add(server);
            }
        }
        return retList.isEmpty() ? serverList : retList;
    }

    public final boolean isRunInDevMode() {
        return this.isRunInDevMode;
    }

    public final void setRunInDevMode(boolean bl) {
        this.isRunInDevMode = bl;
    }

    public DevRibbonServerListFilter(boolean isRunInDevMode) {
        this.isRunInDevMode = isRunInDevMode;
    }

    public final boolean component1() {
        return this.isRunInDevMode;
    }

    @NotNull
    public final DevRibbonServerListFilter copy(boolean isRunInDevMode) {
        return new DevRibbonServerListFilter(isRunInDevMode);
    }

    @NotNull
    public static /* synthetic */ DevRibbonServerListFilter copy$default(DevRibbonServerListFilter devRibbonServerListFilter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = devRibbonServerListFilter.isRunInDevMode;
        }
        return devRibbonServerListFilter.copy(bl);
    }

    @NotNull
    public String toString() {
        return "DevRibbonServerListFilter(isRunInDevMode=" + this.isRunInDevMode + ")";
    }

    public int hashCode() {
        int n = this.isRunInDevMode ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        return n;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DevRibbonServerListFilter)) break block3;
                DevRibbonServerListFilter devRibbonServerListFilter = (DevRibbonServerListFilter)object;
                if (!(this.isRunInDevMode == devRibbonServerListFilter.isRunInDevMode)) break block3;
            }
            return true;
        }
        return false;
    }
}

