/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import java.lang.reflect.Method;

public class FeignClientFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = 6228393678957825891L;
    private String apiName;
    private String[] parameterTypes;
    private byte[] parameterValues;
    private String returnType;
    private byte[] returnValue;
    private String typeName;
    private String methodName;
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.FEIGN_CLIENT;
    }

    public static FeignClientFlowReplaySpan createSpan(Method method, Object[] args, Object ret) {
        Class<?>[] parameterTypeClasses = method.getParameterTypes();
        String[] parameterTypes = null;
        if (parameterTypeClasses.length > 0) {
            parameterTypes = new String[parameterTypeClasses.length];
            for (int i = 0; i < parameterTypeClasses.length; ++i) {
                parameterTypes[i] = parameterTypeClasses[i].getName();
            }
        }
        Class<?> returnTypeClass = method.getReturnType();
        FeignClientFlowReplaySpan span = new FeignClientFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.apiName = FlowReplayUtils.parseApiNameByMethod(method);
        span.parameterTypes = parameterTypes;
        span.parameterValues = KryoSerializer.serialize(args);
        span.returnType = returnTypeClass != null ? returnTypeClass.getName() : null;
        span.typeFullPath = method.getDeclaringClass().getName();
        span.methodName = method.getName();
        span.typeName = method.getDeclaringClass().getSimpleName();
        span.returnValue = KryoSerializer.serialize(ret);
        return span;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object[] getParameterValues() {
        return (Object[])KryoSerializer.deserialize(this.parameterValues);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(this.returnValue);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getTypeFullPath() {
        return this.typeFullPath;
    }
}

