/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;

public class HttpClientFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = -7977781583338574639L;
    private String method;
    private String url;
    private Map<String, List<String>> requestHeaders;
    private Map<String, List<String>> requestParameters;
    private byte[] requestBody;
    private Map<String, List<String>> responseHeaders;
    private String protocol;
    private int major;
    private int minor;
    private int statusCode;
    private String reasonPhrase;
    private byte[] responseBody;

    @Override
    public SpanType getSpanType() {
        return SpanType.HTTP_CLIENT;
    }

    public static HttpClientFlowReplaySpan createSpan(HttpHost httpHost, HttpRequest httpRequest, CloseableHttpResponse response) throws IOException {
        HttpClientFlowReplaySpan span = new HttpClientFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.method = HttpClientFlowReplaySpan.parseMethod(httpRequest);
        span.url = HttpClientFlowReplaySpan.parseUrl(httpHost, httpRequest);
        span.requestHeaders = HttpClientFlowReplaySpan.parseRequestHeaders(httpRequest);
        span.requestParameters = HttpClientFlowReplaySpan.parseRequestParameters(httpRequest);
        span.requestBody = HttpClientFlowReplaySpan.parseRequestBody(httpRequest);
        StatusLine statusLine = response.getStatusLine();
        ProtocolVersion protocolVersion = statusLine.getProtocolVersion();
        span.responseHeaders = HttpClientFlowReplaySpan.parseResponseHeaders(response);
        span.protocol = protocolVersion.getProtocol();
        span.major = protocolVersion.getMajor();
        span.minor = protocolVersion.getMinor();
        span.statusCode = statusLine.getStatusCode();
        span.reasonPhrase = statusLine.getReasonPhrase();
        span.responseBody = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        return span;
    }

    public static String parseMethod(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpUriRequest) {
            HttpUriRequest httpUriRequest = (HttpUriRequest)httpRequest;
            return httpUriRequest.getMethod();
        }
        if (httpRequest instanceof BasicHttpRequest) {
            BasicHttpRequest basicHttpRequest = (BasicHttpRequest)httpRequest;
            return basicHttpRequest.getRequestLine().getMethod();
        }
        throw new FlowReplayException("httpRequest\u672a\u77e5\u5b9e\u73b0_\u5f3a\u8f6c\u5f02\u5e38");
    }

    public static String parseUrl(HttpHost httpHost, HttpRequest httpRequest) {
        String uriStr;
        if (httpRequest instanceof HttpUriRequest) {
            HttpUriRequest httpUriRequest = (HttpUriRequest)httpRequest;
            uriStr = httpUriRequest.getURI().toString();
        } else if (httpRequest instanceof BasicHttpRequest) {
            BasicHttpRequest basicHttpRequest = (BasicHttpRequest)httpRequest;
            uriStr = httpHost.toString() + basicHttpRequest.getRequestLine().getUri();
        } else {
            throw new FlowReplayException("httpRequest\u672a\u77e5\u5b9e\u73b0_\u5f3a\u8f6c\u5f02\u5e38");
        }
        if (uriStr.contains("?")) {
            uriStr = uriStr.substring(0, uriStr.indexOf("?"));
        }
        return uriStr;
    }

    public static Map<String, List<String>> parseResponseHeaders(CloseableHttpResponse response) {
        Header[] allHeaders = response.getAllHeaders();
        return HttpClientFlowReplaySpan.parseHeaders(allHeaders);
    }

    public static Map<String, List<String>> parseRequestHeaders(HttpRequest httpRequest) {
        Header[] allHeaders = httpRequest.getAllHeaders();
        return HttpClientFlowReplaySpan.parseHeaders(allHeaders);
    }

    private static Map<String, List<String>> parseHeaders(Header[] allHeaders) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        if (allHeaders != null && allHeaders.length > 0) {
            for (Header h : allHeaders) {
                List hs = headers.computeIfAbsent(h.getName(), k -> new ArrayList());
                hs.add(h.getValue());
            }
        }
        return headers;
    }

    public static byte[] parseRequestBody(HttpRequest httpRequest) throws IOException {
        byte[] requestBody = null;
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
            requestBody = EntityUtils.toByteArray((HttpEntity)entityEnclosingRequest.getEntity());
        }
        return requestBody;
    }

    public static Map<String, List<String>> parseRequestParameters(HttpRequest httpRequest) throws UnsupportedEncodingException {
        String query;
        if (httpRequest instanceof HttpUriRequest) {
            HttpUriRequest httpUriRequest = (HttpUriRequest)httpRequest;
            query = httpUriRequest.getURI().getQuery();
        } else if (httpRequest instanceof BasicHttpRequest) {
            BasicHttpRequest basicHttpRequest = (BasicHttpRequest)httpRequest;
            query = null;
        } else {
            throw new FlowReplayException("httpRequest\u672a\u77e5\u5b9e\u73b0_\u5f3a\u8f6c\u5f02\u5e38");
        }
        HashMap<String, List<String>> parameter = new HashMap<String, List<String>>();
        if (StringUtils.isBlank((CharSequence)query)) {
            return parameter;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }
            List values = parameter.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return parameter;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> getRequestParameters() {
        return this.requestParameters;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }
}

