/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RedisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordRedisLockMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordRedisLockMethodInterceptor.class);

    private boolean canRecord(Method method, Object[] allArguments) {
        if (!FlowReplayTrace.isTraced()) {
            return false;
        }
        if (!"unlock".equals(method.getName())) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return;
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return;
        }
        IgnoreSubInvokesContext.instMark(obj, method.getName(), allArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return ret;
        }
        if (!IgnoreSubInvokesContext.isInstMarked(obj, method.getName(), allArguments)) {
            return ret;
        }
        try {
            RedisFlowReplaySpan span = RedisFlowReplaySpan.createSpan(method, allArguments, argumentsTypes, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("RedisLock\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("RedisLock\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (FlowReplayTrace.isTraced()) {
            FlowReplayTrace.remove();
        }
    }
}

