/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RocketMqProducerFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order
public class RecordRocketMqProducerPlugin {
    private static final Logger log = LoggerFactory.getLogger(RecordRocketMqProducerPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Object ret;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!FlowReplayTrace.isTraced() || !"send".equals(method.getName())) {
            return joinPoint.proceed();
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return joinPoint.proceed();
        }
        Object[] parameterValues = joinPoint.getArgs();
        Object obj = joinPoint.getTarget();
        IgnoreSubInvokesContext.instMark(obj, method.getName(), parameterValues);
        RocketMqProducerFlowReplaySpan span = null;
        try {
            span = RocketMqProducerFlowReplaySpan.createSpan(signature, parameterValues);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("RocketMq\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("RocketMq\u5f55\u5236_\u5f55\u5236\u5f02\u5e38", t);
        }
        try {
            ret = joinPoint.proceed();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }
        try {
            if (span != null) {
                span.setReturnValue(ret);
            }
        }
        catch (Throwable t) {
            log.error("RocketMq\u5f55\u5236_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }
}

