/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RedisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayRedisLockMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayRedisLockMethodInterceptor.class);

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        if (!"unlock".equals(method.getName())) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("RedisLock\u56de\u653e_traceId={}_spanType={}_spanId={}", new Object[]{ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null});
        if (span == null || SpanType.REDIS != span.getSpanType()) {
            String expert = SpanType.REDIS.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RedisFlowReplaySpan redisSpan = (RedisFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(redisSpan.getMethodName(), method)) {
            String expert = redisSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_102, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            result.defineReturnValue(redisSpan.getReturnValue());
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_104, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

