/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RedisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

@Aspect
public class ReplayRedisTemplatePlugin {
    private static final Logger log = LoggerFactory.getLogger(ReplayRedisTemplatePlugin.class);

    @Around(value="execution(* org.springframework.data.redis.core.RedisTemplate.*(..))")
    public Object customizeSpanReplayAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!"executePipelined".equals(method.getName())) {
            return joinPoint.proceed();
        }
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return joinPoint.proceed();
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("RedisTemplatee\u7684executePipelined\u65b9\u6cd5\u56de\u653e_traceId={}_spanType={}_spanId={}", new Object[]{ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null});
        if (span == null || SpanType.REDIS != span.getSpanType()) {
            String expert = SpanType.REDIS.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RedisFlowReplaySpan redisSpan = (RedisFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(redisSpan.getMethodName(), method)) {
            String expert = redisSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_102, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            return redisSpan.getReturnValue();
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_104, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }
}

