/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.RemoteServiceReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.SpringMvcReplayer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreateReplayer
implements Replayer {
    private static final Logger log = LoggerFactory.getLogger(ConcreateReplayer.class);
    @Resource
    private RemoteServiceReplayer remoteServiceReplayer;
    @Resource
    private SpringMvcReplayer springMvcReplayer;
    private final AtomicInteger currentReplayingTraceCount = new AtomicInteger(0);

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        FlowReplaySpan mainSpan;
        long traceTimestamp;
        if (trace.getSecondsAfterStart() != null && !ReplayContextHolder.isMockSysTimeValid(traceTimestamp = ReplayContextHolder.calculateTraceTimestamp(trace.getSecondsAfterStart()))) {
            do {
                if (this.currentReplayingTraceCount.get() == 0) {
                    ReplayContextHolder.setMockSysTime(traceTimestamp);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (!Thread.currentThread().isInterrupted());
        }
        if ((mainSpan = trace.getMainSpan()) == null) {
            throw new FlowReplayException("\u65e0\u6548\u7684trace_traceId_" + trace.getTraceId());
        }
        try {
            this.currentReplayingTraceCount.incrementAndGet();
            switch (mainSpan.getSpanType()) {
                case REMOTE_SERVICE: {
                    ReplayTraceResult replayTraceResult = this.remoteServiceReplayer.replay(trace);
                    return replayTraceResult;
                }
                case SPRING_MVC: {
                    ReplayTraceResult replayTraceResult = this.springMvcReplayer.replay(trace);
                    return replayTraceResult;
                }
            }
            throw new FlowReplayException("\u6682\u4e0d\u652f\u6301\u7684\u56de\u653e\u7c7b\u578b_traceId_" + trace.getTraceId());
        }
        finally {
            this.currentReplayingTraceCount.decrementAndGet();
        }
    }
}

