/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast;

import ch.qos.logback.classic.Level;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DuibaEurekaAutoServiceRegistration;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastPortConfiguration;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastProperties;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.EurekaOneDiscoveryStrategy;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.EurekaOneDiscoveryStrategyFactory;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.HazelcastEndpoint;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.MockHazelcastInstance;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.properties.GroupProperty;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClient;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuibaHazelcastPortConfiguration.class})
@ConditionalOnClass(value={EurekaClient.class})
@AutoConfigureBefore(value={HazelcastAutoConfiguration.class})
@EnableConfigurationProperties(value={DuibaHazelcastProperties.class})
public class DuibaHazelcastAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DuibaHazelcastAutoConfiguration.class);
    public static final String SPRING_APPLICATION_CONTEXT_KEY = "applicationContext";
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private EurekaClient eurekaClient;
    @Resource
    private DuibaEurekaAutoServiceRegistration duibaEurekaAutoServiceRegistration;
    @Resource
    private ApplicationInfoManager applicationInfoManager;
    @Resource
    private DuibaHazelcastProperties duibaHazelcastProperties;

    @Bean
    public Config hazelcastConfig(DuibaHazelcastPortConfiguration duibaHazelcastPortConfiguration) {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getAwsConfig().setEnabled(false);
        Map metadata = this.applicationInfoManager.getInfo().getMetadata();
        config.getMemberAttributeConfig().getAttributes().putAll(metadata);
        config.getUserContext().put(SPRING_APPLICATION_CONTEXT_KEY, this.applicationContext);
        config.getNetworkConfig().setPort(duibaHazelcastPortConfiguration.getHazelcastPort());
        config.getNetworkConfig().setPortAutoIncrement(false);
        config.setProperty("hazelcast.discovery.enabled", "true");
        config.setProperty("hazelcast.logging.type", "slf4j");
        config.setProperty("hazelcast.local.localAddress", NetUtils.getLocalIp());
        config.setProperty("hazelcast.socket.server.bind.any", "false");
        config.setProperty("hazelcast.heartbeat.failuredetector.type", "deadline");
        config.setProperty("hazelcast.heartbeat.interval.seconds", "5");
        config.setProperty("hazelcast.max.no.heartbeat.seconds", "20");
        config.setProperty(GroupProperty.SOCKET_CONNECT_TIMEOUT_SECONDS.getName(), "2");
        for (Map.Entry<String, String> entry : this.duibaHazelcastProperties.getProperties().entrySet()) {
            config.setProperty(entry.getKey(), entry.getValue());
        }
        HashMap eurekaStrategyProperties = new HashMap();
        EurekaOneDiscoveryStrategyFactory.setEurekaClient(this.eurekaClient);
        config.getNetworkConfig().getJoin().getDiscoveryConfig().addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(EurekaOneDiscoveryStrategy.class.getName(), eurekaStrategyProperties));
        return config;
    }

    @Bean
    public static HazelcastEndpoint hazelcastEndpoint() {
        return new HazelcastEndpoint();
    }

    static {
        ((ch.qos.logback.classic.Logger)log).setLevel(Level.INFO);
    }

    @Configuration
    @ConditionalOnProperty(name={"org.springframework.boot.test.context.SpringBootTestContextBootstrapper", "duiba.test.mock.hazelcast"}, havingValue="true")
    static class MockHazelcastInstanceConfiguration {
        MockHazelcastInstanceConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance(Config config) {
            log.info("\u68c0\u6d4b\u5230\u5f53\u524d\u6b63\u5728\u6267\u884c\u5355\u5143\u6d4b\u8bd5\uff0cmock \u4e00\u4e2a HazelcastInstance ");
            return new MockHazelcastInstance();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"org.springframework.boot.test.context.SpringBootTestContextBootstrapper", "duiba.test.mock.hazelcast"}, havingValue="false", matchIfMissing=true)
    static class HazelcastInstanceConfiguration {
        HazelcastInstanceConfiguration() {
        }

        @Bean(destroyMethod="shutdown")
        public HazelcastInstance hazelcastInstance(Config config) {
            this.checkVersion();
            long start = System.currentTimeMillis();
            HazelcastInstance instance = new HazelcastInstanceFactory(config).getHazelcastInstance();
            long cost = System.currentTimeMillis() - start;
            log.info("hazelcast is initted in {}ms, clusterState:{}, version:{}, members:{}", new Object[]{cost, instance.getCluster().getClusterState(), instance.getCluster().getClusterVersion(), instance.getCluster().getMembers()});
            return instance;
        }

        private void checkVersion() {
            String version;
            Package pkg = HazelcastInstance.class.getPackage();
            String string = version = pkg != null ? pkg.getImplementationVersion() : null;
            if (!version.equals("3.11") && !version.startsWith("3.11.")) {
                throw new IllegalStateException("\u8bf7\u628ahazelcast\u7248\u672c\u5347\u7ea7\u52303.11.*\u7248\u672c, \u5728\u4f60\u7684gradle\u6587\u4ef6\u4e2d\u52a0\u5165\u8fd9\u4e2a\u914d\u7f6e\u5373\u53ef\u5347\u7ea7\uff1aext['hazelcast.version']='3.11' ");
            }
        }
    }
}

