/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class RocketMqPerfAspect {
    @Autowired(required=false)
    private PerfTestFootMarker perfTestFootMarker;
    private static final String PERF_TEST_PROPERTY = "perfTest";
    private static final Logger logger = LoggerFactory.getLogger(RocketMqPerfAspect.class);

    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("send") && signature.getParameterTypes().length >= 1 && signature.getParameterTypes()[0].equals(Message.class) && InternalPerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo((String)"rocketMQProducer");
            Object[] args = joinPoint.getArgs();
            Message m = (Message)args[0];
            if (m != null) {
                m.putUserProperty(PERF_TEST_PROPERTY, "true");
                String sceneId = InternalPerfTestContext.getCurrentSceneId();
                boolean isTestCluster = InternalPerfTestContext.isTestCluster();
                if (StringUtils.isNotBlank((CharSequence)sceneId)) {
                    m.putUserProperty("_duibaPerfSceneId", sceneId);
                    m.putUserProperty("_duibaPerfTestCluster", String.valueOf(isTestCluster));
                }
            }
            return joinPoint.proceed(args);
        }
        return joinPoint.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.apache.rocketmq.client.consumer.listener.MessageListener+.*(..))")
    public Object rocketMqConsumerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("consumeMessage") && signature.getParameterTypes().length >= 1 && signature.getParameterTypes()[0].equals(List.class)) {
            Object[] args = joinPoint.getArgs();
            List list = (List)args[0];
            if (list != null && list.size() == 1) {
                MessageExt m = (MessageExt)list.get(0);
                if ("true".equals(m.getUserProperty(PERF_TEST_PROPERTY))) {
                    if (this.perfTestFootMarker == null) {
                        MessageListener listener = (MessageListener)joinPoint.getTarget();
                        if (listener instanceof MessageListenerConcurrently) {
                            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                        }
                        if (listener instanceof MessageListenerOrderly) {
                            return ConsumeOrderlyStatus.SUCCESS;
                        }
                        logger.error("[NOTIFYME]\u5c1a\u672a\u652f\u6301\u7684rocketmq messageListener");
                    }
                    String perfTestSceneId = m.getUserProperty("_duibaPerfSceneId");
                    boolean isTestCluster = Boolean.valueOf(m.getUserProperty("_duibaPerfTestCluster"));
                    InternalPerfTestContext.markAsPerfTest((String)perfTestSceneId, (boolean)isTestCluster);
                    this.perfTestFootMarker.markApp();
                    PerfTestContext.debugInfo((String)"rocketMQConsumer");
                    try {
                        Object object = joinPoint.proceed();
                        return object;
                    }
                    finally {
                        InternalPerfTestContext.markAsNormal();
                    }
                }
            } else if (list != null && list.size() > 1) {
                ArrayList<MessageExt> newList = new ArrayList<MessageExt>();
                for (MessageExt m : list) {
                    if ("true".equals(m.getUserProperty(PERF_TEST_PROPERTY))) continue;
                    newList.add(m);
                }
                if (newList.size() != list.size()) {
                    logger.warn("\u68c0\u6d4b\u5230rocketmq\u6d88\u8d39\u8005\u4e2d\u4e00\u6b21\u6d88\u8d39\u4e86\u591a\u6761\u6d88\u606f\u4e14\u6d88\u606f\u4e2d\u6709\u538b\u6d4b\u6d88\u606f\uff0c\u5c06\u4e22\u5f03\u5176\u4e2d\u7684\u538b\u6d4b\u6d88\u606f\uff08\u5982\u9700\u652f\u6301\u538b\u6d4b\u8bf7\u8bbe\u7f6eDefaultMQPushConsumer.setConsumeMessageBatchMaxSize \u4e3a1\uff09");
                    args[0] = newList;
                    return joinPoint.proceed(args);
                }
            }
        }
        return joinPoint.proceed();
    }
}

