/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.BizExceptionResolver;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomWebMvcRegistrations;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebMvcFixAutoConfiguration {
    @Bean(name={"viewResolver"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
    public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
        ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
        resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
        resolver.setOrder(Integer.MAX_VALUE);
        return resolver;
    }

    @Bean
    public BizExceptionResolver bizExceptionResolver() {
        return new BizExceptionResolver();
    }

    @Bean
    public CustomWebMvcRegistrations customWebMvcRegistrations() {
        return new CustomWebMvcRegistrations();
    }

    @Bean
    public static SpecifiedBeanPostProcessor httpMessageConvertersPostProcessor() {
        return new SpecifiedBeanPostProcessor<HttpMessageConverters>(){

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<HttpMessageConverters> getBeanType() {
                return HttpMessageConverters.class;
            }

            @Override
            public Object postProcessBeforeInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                List converters = bean.getConverters();
                return new CustomHttpMessageConverters(false, converters == null ? Collections.emptyList() : converters);
            }
        };
    }
}

