package cn.com.duibaboot.ext.autoconfigure.actuate;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 自定义的安全拦截器，对于/refresh， /restart, /env 等http endpoint接口，会判断来源IP，只允许内网执行
 */
public class CustomMvcEndpointSecurityInterceptor extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CustomMvcEndpointSecurityInterceptor.class);

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return canContinue(request, response);
    }

    public static boolean canContinue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isLanReq = HttpRequestUtils.isLanRequest(request);
        if(!isLanReq){
            customSendFailureResponse(request, response);
        }
        return isLanReq;
    }

    private static void customSendFailureResponse(HttpServletRequest request,
                                           HttpServletResponse response) throws IOException {
        logUnauthorizedAttempt(request);
        response.sendError(HttpStatus.FORBIDDEN.value(),
                "Access is denied. ");
    }

    private static void logUnauthorizedAttempt(HttpServletRequest request) {
        logger.warn("Someone from internet[ip:{}] try to access actuator endpoints:[{}], Deny this request", RequestTool.getIpAddr(request), RequestUtils.getRequestPath(request));
    }
}
