package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.internal.DefaultTransaction;
import org.springframework.core.Ordered;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

/**
 * 把url访问记录到cat,for reactive/webflux, 当前类不会在gateway中生效
 *
 * Created by hwq .
 * 2017/11/30 .
 */
public class CatReactiveWebFilter implements WebFilter, Ordered {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if(!CatUtils.isCatEnabled()){
            return chain.filter(exchange);
        }

        if ("true".equals(exchange.getRequest().getHeaders().getFirst(CustomRequestInterceptor.X_RPC))) {
            //不处理RPC请求（来自FeignClient的rest rpc调用）
            return chain.filter(exchange);
        }

        //记录开始时间
        final long startTime = System.nanoTime();

        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            recordInCatTransaction(exchange, startTime, null);
        })).doOnError(throwable -> {
            recordInCatTransaction(exchange, startTime, throwable);
        }).then();
    }

    private void recordInCatTransaction(ServerWebExchange exchange, long catStartTime, Throwable throwable){
        //记录应用-url级别的transaction
        String path = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if(path == null) {
            path = exchange.getRequest().getURI().getPath();
        }
        DefaultTransaction webUrlTransaction = (DefaultTransaction)Cat.newTransaction("URL", path);

        webUrlTransaction.setDurationStart(catStartTime);

        try {
            Throwable exToLog = throwable;

            if (exToLog == null) {
                webUrlTransaction.setStatus(Message.SUCCESS);
            } else {
                webUrlTransaction.setStatus(exToLog);
                Cat.logError(exToLog);
            }
        } finally {
            webUrlTransaction.complete();
        }
    }

    @Override
    public int getOrder() {
        return -100;
    }
}
