package cn.com.duibaboot.ext.autoconfigure.dbexec;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Schedulers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

/**
 * 执行命令的端点
 * Created by guoyanfei .
 * 2018/5/28 .
 */
@ControllerEndpoint(id="dbexec")
//@Controller
public class ExecMvcEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExecMvcEndpoint.class);

    private static final ExecutorService es =  new ThreadPoolExecutor(5, 5,
                                                                      0L, TimeUnit.MILLISECONDS,
                                                                      new SynchronousQueue<>(), new NamedThreadFactory("dbexec"));
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{commandKey}"
    )
    public Flux<ServerSentEvent<String>> invoke(@PathVariable String commandKey) {
        if (StringUtils.isBlank(commandKey)) {
            throw new RuntimeException("commandKey 不能为 null");
        }
        if (!ExecutableCommand.contains(commandKey)) {
            throw new RuntimeException("非法的 commandKey");
        }
        return buildSseEmitter(ExecutableCommand.get(commandKey));
    }

    private Flux<ServerSentEvent<String>> buildSseEmitter(ExecutableCommand executableCommand) {
        String command = this.renderCommand(executableCommand);
        return Flux.create((Consumer<FluxSink<ServerSentEvent<String>>>) s -> {
            Process process;
            try {
                process = Runtime.getRuntime().exec(command);
            } catch (IOException e) {
                LOGGER.error("", e);
                s.error(e);
                return;
            }
            try(InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader)) {

                String line;
                while ((line = lineNumberReader.readLine()) != null) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("execReuslt", line);

                    s.next(ServerSentEvent.<String>builder().data(jsonObject.toString()).build());
                }
            } catch (Exception e) {
                LOGGER.error("", e);
                s.error(e);
            } finally {
                if (process != null) {
                    process.destroy();
                }
                s.complete();
            }
        }).subscribeOn(Schedulers.fromExecutor(es));
    }

    /**
     * 命令中的填充插值
     * @param commandEnum
     * @return
     */
    private String renderCommand(ExecutableCommand commandEnum) {
        String command = commandEnum.getCommand();
        command = command.replace("${vmid}", JvmIdTool.getVmId());
        return command;
    }

}
