/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMessageManager;
import com.dianping.cat.message.internal.DefaultTransaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.unidal.helper.Joiners;

public class CatHandlerInterceptor
implements HandlerInterceptor {
    private static List<Handler> mHandlers = new ArrayList<Handler>();

    private void customizeStatus(Transaction t, HttpServletRequest req) {
        Object catStatus = req.getAttribute("cat-state");
        if (catStatus != null) {
            t.setStatus(catStatus.toString());
        } else {
            t.setStatus("0");
        }
    }

    private void customizeUri(Transaction t, HttpServletRequest req) {
        if (t instanceof DefaultTransaction) {
            Object catPageUri;
            Object catPageType = req.getAttribute("cat-page-type");
            if (catPageType instanceof String) {
                ((DefaultTransaction)t).setType(catPageType.toString());
            }
            if ((catPageUri = req.getAttribute("cat-page-uri")) instanceof String) {
                ((DefaultTransaction)t).setName(catPageUri.toString());
            }
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!CatUtils.isCatEnabled()) {
            return true;
        }
        if (DispatcherType.FORWARD != request.getDispatcherType() && DispatcherType.REQUEST != request.getDispatcherType()) {
            return true;
        }
        Context ctx = new Context(request, response, mHandlers);
        ctx.handle();
        String uri = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        Cat.newTransaction((String)ctx.getType(), (String)uri);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (DispatcherType.FORWARD != request.getDispatcherType() && DispatcherType.REQUEST != request.getDispatcherType()) {
            return;
        }
        Transaction t = Cat.getManager().getPeekTransaction();
        if (t == null) {
            return;
        }
        try {
            if (ex == null) {
                this.customizeStatus(t, request);
            } else {
                t.setStatus((Throwable)ex);
                Cat.logError((Throwable)ex);
            }
        }
        finally {
            this.customizeUri(t, request);
            t.complete();
        }
    }

    static {
        mHandlers.add(CatHandler.ENVIRONMENT);
        mHandlers.add(CatHandler.LOG_CLIENT_PAYLOAD);
        mHandlers.add(CatHandler.ID_SETUP);
    }

    private static enum CatHandler implements Handler
    {
        ENVIRONMENT{

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                HttpServletRequest req = ctx.getRequest();
                boolean top = !Cat.getManager().hasContext();
                ctx.setTop(top);
                if (top) {
                    ctx.setType("URL");
                    this.setTraceMode(req);
                } else {
                    ctx.setType("URL.Forward");
                }
                ctx.handle();
            }

            protected void setTraceMode(HttpServletRequest req) {
                String traceMode = "X-CAT-TRACE-MODE";
                String headMode = req.getHeader(traceMode);
                if ("true".equals(headMode)) {
                    Cat.getManager().setTraceMode(true);
                }
            }
        }
        ,
        ID_SETUP{
            private String mServers;

            private String getCatServer() {
                if (this.mServers == null) {
                    DefaultMessageManager manager = (DefaultMessageManager)Cat.getManager();
                    List servers = manager.getConfigManager().getServers();
                    this.mServers = Joiners.by((char)',').join((Collection)servers, server -> {
                        if (server == null) {
                            return "";
                        }
                        String ip = server.getIp();
                        Integer httpPort = server.getHttpPort();
                        return ip + ":" + httpPort;
                    });
                }
                return this.mServers;
            }

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                boolean isTraceMode = Cat.getManager().isTraceMode();
                HttpServletResponse res = ctx.getResponse();
                if (isTraceMode) {
                    String id = Cat.getCurrentMessageId();
                    res.setHeader("X-CAT-ROOT-ID", id);
                    res.setHeader("X-CAT-SERVER", this.getCatServer());
                }
                ctx.handle();
            }
        }
        ,
        LOG_CLIENT_PAYLOAD{

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                HttpServletRequest req = ctx.getRequest();
                String type = ctx.getType();
                if (ctx.isTop()) {
                    this.logRequestClientInfo(req, type);
                    this.logRequestPayload(req, type);
                } else {
                    this.logRequestPayload(req, type);
                }
                ctx.handle();
            }

            protected void logRequestClientInfo(HttpServletRequest req, String type) {
                StringBuilder sb = new StringBuilder(1024);
                String ip = "";
                String ipForwarded = req.getHeader("x-forwarded-for");
                ip = ipForwarded == null ? req.getRemoteAddr() : ipForwarded;
                sb.append("IPS=").append(ip);
                sb.append("&VirtualIP=").append(req.getRemoteAddr());
                sb.append("&Server=").append(req.getServerName());
                sb.append("&Referer=").append(req.getHeader("referer"));
                sb.append("&Agent=").append(req.getHeader("user-agent"));
                Cat.logEvent((String)type, (String)(type + ".Server"), (String)"0", (String)sb.toString());
            }

            protected void logRequestPayload(HttpServletRequest req, String type) {
                StringBuilder sb = new StringBuilder(256);
                sb.append(req.getScheme().toUpperCase()).append('/');
                sb.append(req.getMethod()).append(' ').append(req.getRequestURI());
                String qs = req.getQueryString();
                if (qs != null) {
                    sb.append('?').append(qs);
                }
                Cat.logEvent((String)type, (String)(type + ".Method"), (String)"0", (String)sb.toString());
            }
        };

    }

    protected static class Context {
        private List<Handler> mHandlers;
        private int mIndex;
        private HttpServletRequest mRequest;
        private HttpServletResponse mResponse;
        private boolean mTop;
        private String mType;

        public Context(HttpServletRequest request, HttpServletResponse response, List<Handler> handlers) {
            this.mRequest = request;
            this.mResponse = response;
            this.mHandlers = handlers;
        }

        public HttpServletRequest getRequest() {
            return this.mRequest;
        }

        public HttpServletResponse getResponse() {
            return this.mResponse;
        }

        public String getType() {
            return this.mType;
        }

        public void handle() throws IOException, ServletException {
            if (this.mIndex < this.mHandlers.size()) {
                Handler handler = this.mHandlers.get(this.mIndex++);
                handler.handle(this);
            }
        }

        public boolean isTop() {
            return this.mTop;
        }

        public void setTop(boolean top) {
            this.mTop = top;
        }

        public void setType(String type) {
            this.mType = type;
        }
    }

    protected static interface Handler {
        public void handle(Context var1) throws IOException, ServletException;
    }
}

