/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.CommonDiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonDiscoveryMetadataRegister.class})
@ConditionalOnClass(value={EurekaInstanceConfig.class})
public class DiscoveryMetadataAutoConfiguration {
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";
    public static final String DUIBA_WARMUP_TIMEMILLIS = "duiba.warmup.timemillis";
    public static final String RUN_IN_SINGLE_JAR_MODE = "runInSingleJarMode";
    public static final String DUIBA_BOOT_VERSION = "duibaBootVersion";
    public static final String SPRING_BOOT_VERSION = "springBootVersion";
    public static final String CONFIG_VERSION = "configVersion";
    public static final String RUN_IN_DOCKER = "run.in.docker";
    public static final String DUIBA_PERF_SCENE_ID = "duiba.perf.scene.id";
    public static final String DUIBA_SERVICE_GROUP_KEY = "duiba.service.group.key";

    @Bean
    public static SpecifiedBeanPostProcessor eurekaInstanceConfigBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<EurekaInstanceConfig>(){
            @Resource
            private ApplicationContext applicationContext;

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<EurekaInstanceConfig> getBeanType() {
                return EurekaInstanceConfig.class;
            }

            @Override
            public Object postProcessBeforeInitialization(EurekaInstanceConfig bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(EurekaInstanceConfig bean, String beanName) throws BeansException {
                DiscoveryMetadataAutoConfiguration.refreshMetadata(bean, this.applicationContext);
                return bean;
            }
        };
    }

    static void refreshMetadata(EurekaInstanceConfig bean, ApplicationContext applicationContext) {
        Collection registers = applicationContext.getBeansOfType(DiscoveryMetadataRegister.class).values();
        if (registers != null) {
            for (DiscoveryMetadataRegister register : registers) {
                register.registerMetadata(bean.getMetadataMap());
            }
        }
    }

    static void refreshMetadata(ApplicationInfoManager applicationInfoManager, ApplicationContext applicationContext) {
        Collection registers = applicationContext.getBeansOfType(DiscoveryMetadataRegister.class).values();
        if (registers != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (DiscoveryMetadataRegister register : registers) {
                register.registerMetadata(metadata);
            }
            applicationInfoManager.registerAppMetadata(metadata);
        }
    }
}

