/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.alibaba.fastjson.JSON;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class DuibaDataSourceMonitor
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DuibaDataSourceMonitor.class);
    private static final boolean HIKARI_CLASS_EXISTS;
    private static final boolean HIKARI_MONITOR_EXISTS;
    private static final boolean DBCP2_CLASS_EXISTS;
    private boolean initted = false;
    private Map<String, DataSource> dataSourceMap;
    private Thread duibaDataSourceMonitorThread;
    private static final long RETENTION_TIME = 1800000L;
    private Map<String, Map<Long, MonitorObj>> secondMonitorMap = new ConcurrentHashMap<String, Map<Long, MonitorObj>>();

    protected synchronized String getSecondMonitorJson() {
        return JSON.toJSONString(this.secondMonitorMap);
    }

    public synchronized void startMonitorThread(ApplicationContext context) {
        if (!this.initted) {
            this.initted = true;
            this.dataSourceMap = context.getBeansOfType(DataSource.class);
            if (this.dataSourceMap.isEmpty()) {
                return;
            }
            this.duibaDataSourceMonitorThread = new Thread(() -> this.scanDataSources(), "duibaDataSourceMonitorThread");
            this.duibaDataSourceMonitorThread.start();
        }
    }

    private void scanDataSources() {
        do {
            for (Map.Entry<String, DataSource> entry : this.dataSourceMap.entrySet()) {
                DataSource ds = entry.getValue();
                if (ds instanceof PerfTestRoutingDataSource) {
                    PerfTestRoutingDataSource pds = (PerfTestRoutingDataSource)((Object)ds);
                    this.scanDataSource(entry.getKey(), pds.getOriginalDataSource());
                    this.scanDataSource(entry.getKey() + "_shade", pds.getShadeDataSource());
                    continue;
                }
                this.scanDataSource(entry.getKey(), ds);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!Thread.currentThread().isInterrupted());
    }

    private synchronized void scanDataSource(String key, DataSource ds) {
        if (this.isValid(ds)) {
            MonitorObj currentMonitorObj = this.getCurrentMonitorObj(ds);
            if (currentMonitorObj == null) {
                return;
            }
            this.warnIfTooFull(key, currentMonitorObj);
            Map dbSecondMonitorMap = this.secondMonitorMap.computeIfAbsent(key, s -> new LinkedHashMap<Long, MonitorObj>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MonitorObj> eldest) {
                    return eldest.getKey() < System.currentTimeMillis() - 1800000L;
                }
            });
            dbSecondMonitorMap.put(System.currentTimeMillis(), currentMonitorObj);
        }
    }

    private void warnIfTooFull(String key, MonitorObj currentMonitorObj) {
        int numIdleConnections = currentMonitorObj.getNumAllocated() - currentMonitorObj.getNumActive();
        if (currentMonitorObj.getNumActive() >= 3 && currentMonitorObj.getNumAllocated() >= currentMonitorObj.getMaxTotal() - 3 && currentMonitorObj.getNumActive() >= currentMonitorObj.getNumAllocated() - 3) {
            log.error("datasource [" + key + "]'s connectionPool is too full,max:" + currentMonitorObj.getMaxTotal() + ",busy:" + currentMonitorObj.getNumActive() + ",idle:" + numIdleConnections);
        }
    }

    private MonitorObj getCurrentMonitorObj(DataSource ds) {
        if (DBCP2_CLASS_EXISTS && ds instanceof BasicDataSource) {
            BasicDataSource ds1 = (BasicDataSource)ds;
            int numIdleConnections = ds1.getNumIdle();
            int numActiveConnections = ds1.getNumActive();
            int maxTotal = ds1.getMaxTotal();
            return new MonitorObj(numIdleConnections, numActiveConnections, maxTotal, -1);
        }
        if (HIKARI_CLASS_EXISTS && ds instanceof HikariDataSource) {
            if (HIKARI_MONITOR_EXISTS) {
                HikariDataSource ds1 = (HikariDataSource)ds;
                HikariPoolMXBean poolMXBean = ds1.getHikariPoolMXBean();
                int numIdleConnections = poolMXBean.getIdleConnections();
                int numActiveConnections = poolMXBean.getActiveConnections();
                int maxTotal = ((HikariDataSource)ds).getMaximumPoolSize();
                int threadsAwaitingConnection = poolMXBean.getThreadsAwaitingConnection();
                return new MonitorObj(numIdleConnections, numActiveConnections, maxTotal, threadsAwaitingConnection);
            }
            return null;
        }
        throw new IllegalStateException("[notifyme]will not be here");
    }

    private boolean isValid(DataSource ds) {
        if (ds != null) {
            if (DBCP2_CLASS_EXISTS && ds instanceof BasicDataSource && !((BasicDataSource)ds).isClosed()) {
                return true;
            }
            if (HIKARI_CLASS_EXISTS && ds instanceof HikariDataSource && !((HikariDataSource)ds).isClosed()) {
                return true;
            }
        }
        return false;
    }

    public synchronized void destroy() throws Exception {
        if (this.duibaDataSourceMonitorThread != null) {
            this.duibaDataSourceMonitorThread.interrupt();
        }
    }

    static {
        boolean hikariClassExists = false;
        boolean hikariMonitorExists = false;
        boolean dbcp2ClassExists = false;
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariClassExists = true;
            HikariDataSource.class.getDeclaredMethod("getHikariPoolMXBean", new Class[0]);
            hikariMonitorExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException e) {
            log.warn("\u8bf7\u628ahikari\u5347\u7ea7\u5230\u6700\u65b0\u7248\uff0c\u5426\u5219\u65e0\u6cd5\u76d1\u63a7\u8fde\u63a5\u6c60\u4f7f\u7528\u6570\u636e");
        }
        HIKARI_MONITOR_EXISTS = hikariMonitorExists;
        try {
            Class.forName("org.apache.commons.dbcp2.BasicDataSource");
            dbcp2ClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HIKARI_CLASS_EXISTS = hikariClassExists;
        DBCP2_CLASS_EXISTS = dbcp2ClassExists;
    }

    public static class MonitorObj {
        private short numActive;
        private short numAllocated;
        private short maxTotal;
        private short threadsAwaitingConnection;

        public MonitorObj(int numIdleConnections, int numActiveConnections, int maxTotal, int threadsAwaitingConnection) {
            this.numActive = (short)numActiveConnections;
            this.maxTotal = (short)maxTotal;
            this.numAllocated = (short)(numActiveConnections + numIdleConnections);
            this.threadsAwaitingConnection = (short)threadsAwaitingConnection;
        }

        public MonitorObj() {
        }

        public short getNumActive() {
            return this.numActive;
        }

        public short getNumAllocated() {
            return this.numAllocated;
        }

        public short getMaxTotal() {
            return this.maxTotal;
        }

        public short getThreadsAwaitingConnection() {
            return this.threadsAwaitingConnection;
        }
    }
}

