/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import cn.com.duiba.boot.cat.CatWithArgs;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatContext;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;

public class CustomFeignClientFactoryBean
extends FeignClientFactoryBean {
    private String springApplicationName;

    public Object getObject() throws Exception {
        Class classType = super.getObjectType();
        Object feignClient = super.getObject();
        if (CatUtils.isCatClassExists()) {
            return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandlerWithCat(this.springApplicationName, feignClient, this.getName()));
        }
        return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandler(this.springApplicationName, feignClient, this.getName()));
    }

    public void setSpringApplicationName(String springApplicationName) {
        this.springApplicationName = springApplicationName;
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandlerWithCat
    extends FeignClientInvocationHandler {
        FeignClientInvocationHandlerWithCat(String springApplicationName, Object original, String serverName) {
            super(springApplicationName, original, serverName);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            RpcContext.getContext().setInvokeArgs(args);
            RpcContext.getContext().setSourceServiceId(this.springApplicationName);
            RpcContext.getContext().setTargetServiceId(this.serverName);
            if (!CatUtils.isCatEnabled()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            return this.invokeWithCatTransaction(method, args);
        }

        private Object invokeWithCatTransaction(Method method, Object[] args) throws Throwable {
            String loggerName = this.resolveLoggerName(method, args);
            Transaction transaction = Cat.newTransaction((String)"PigeonCall", (String)loggerName);
            try {
                CatContext context = new CatContext();
                Cat.logRemoteCallClient((Cat.Context)context);
                this.setAttachment(context, method);
                Object result = this.invokeMethodInner(method, this.original, args);
                transaction.setStatus("0");
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                if (!(e instanceof BizException)) {
                    Cat.logError((Throwable)e);
                    transaction.setStatus(e);
                } else {
                    Event bizExceptionEvent = Cat.newEvent((String)"BizException", (String)String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", e.getMessage(), ((BizException)e).getCode()));
                    AbstractMessage message = (AbstractMessage)bizExceptionEvent;
                    message.setCompleted(true);
                    message.setStatus("0");
                    transaction.addChild((Message)bizExceptionEvent);
                    transaction.setStatus("0");
                }
                throw e;
            }
            finally {
                Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)(this.springApplicationName + "[" + RpcContext.getContext().getLocalAddr() + "]"));
                Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)(this.serverName + "[" + RpcContext.getContext().getRemoteAddr() + "]"));
                transaction.addChild((Message)crossAppEvent);
                transaction.addChild((Message)crossServerEvent);
                CatUtils.completeTransaction(transaction);
            }
        }

        private String resolveLoggerName(Method method, Object[] args) {
            StringBuilder loggerName = new StringBuilder(method.getDeclaringClass().getSimpleName()).append(".").append(method.getName());
            if (method.isAnnotationPresent(CatWithArgs.class)) {
                CatWithArgs catWithArgs = method.getAnnotation(CatWithArgs.class);
                int[] argIndexes = catWithArgs.argIndexes();
                if (argIndexes == null || argIndexes.length == 0 || args == null || args.length == 0) {
                    return loggerName.toString();
                }
                StringBuilder sb = new StringBuilder();
                for (int argIdx : argIndexes) {
                    if (argIdx < 0 || args.length <= argIdx) continue;
                    Object obj = args[argIdx];
                    sb.append(obj == null ? "" : obj.toString()).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.insert(0, "(");
                    sb.append(")");
                }
                loggerName.append((CharSequence)sb);
            }
            return loggerName.toString();
        }

        private void setAttachment(CatContext context, Method method) {
            RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
            RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
            RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
            RpcContext.getContext().setAttachment("X-Rpc-Client", this.springApplicationName);
        }
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandler
    implements InvocationHandler {
        protected final String springApplicationName;
        protected final String serverName;
        protected final Object original;

        FeignClientInvocationHandler(String springApplicationName, Object original, String serverName) {
            this.springApplicationName = springApplicationName;
            this.original = original;
            this.serverName = serverName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            RpcContext.getContext().setInvokeArgs(args);
            RpcContext.getContext().setSourceServiceId(this.springApplicationName);
            RpcContext.getContext().setTargetServiceId(this.serverName);
            return this.invokeMethodInner(method, this.original, args);
        }

        protected Object invokeMethodInner(Method method, Object target, Object[] args) throws Throwable {
            try {
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof HystrixBadRequestException && e.getCause() != null && e.getCause() instanceof BizException) {
                    e = e.getCause();
                }
                throw e;
            }
        }
    }
}

