/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.OverrideCallable;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMethodsInterWithOverrideArgs {
    private static final Logger logger = LoggerFactory.getLogger((String)StaticMethodsInterWithOverrideArgs.class.getName());
    private List<StaticMethodsAroundInterceptor> interceptors = new ArrayList<StaticMethodsAroundInterceptor>();

    public StaticMethodsInterWithOverrideArgs(String staticMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            String[] classNames;
            for (String className : classNames = staticMethodsAroundInterceptorClassName.split(",")) {
                StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(className, classLoader);
                this.interceptors.add(interceptor);
            }
        }
        catch (Throwable t) {
            throw new PluginException("Can't create StaticMethodsAroundInterceptor.", t);
        }
    }

    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @Morph(defaultMethod=false) OverrideCallable zuper) throws Throwable {
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            for (StaticMethodsAroundInterceptor interceptor : this.interceptors) {
                interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
            }
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("class[" + clazz + "] before static method[" + method.getName() + "] intercept failure");
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                    StaticMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                    interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
                }
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Throwable t2) {
                logger.error("class[" + clazz + "] handle static method[" + method.getName() + "] exception failure", t2);
            }
            throw t;
        }
        finally {
            try {
                for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                    StaticMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                    ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                }
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Throwable t) {
                logger.error("class[" + clazz + "] after static method[" + method.getName() + "] failure", t);
            }
        }
        return ret;
    }
}

