/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import java.lang.reflect.Field;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.util.ReflectionUtils;

public class MonitorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRunnable.class);
    private static final boolean IS_SLEUTH_CLASS_EXISTS;
    private static final Field DELEGATE_FIELD;
    private Runnable runnable;
    private BlockingQueue<Runnable> queue;
    private final int maxWaitTimeMillis;
    private final long submitTimeMillis;

    public MonitorRunnable(Runnable runnable) {
        this(runnable, null);
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue) {
        this(runnable, queue, 1000);
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue, int maxWaitTimeMillis) {
        this.runnable = runnable;
        this.queue = queue;
        this.submitTimeMillis = System.currentTimeMillis();
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    public long getSubmitTimeMillis() {
        return this.submitTimeMillis;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void run() {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= (long)this.maxWaitTimeMillis) {
            if (this.queue == null) {
                logger.warn("RunnableClass:{}, ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.warn("RunnableClass:{}, ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        this.runnable.run();
    }

    protected Runnable getRootRunnable() {
        Runnable tmp;
        Runnable rootRunnable = this.getRunnable();
        if (IS_SLEUTH_CLASS_EXISTS && rootRunnable instanceof TraceRunnable && (tmp = (Runnable)ReflectionUtils.getField((Field)DELEGATE_FIELD, (Object)rootRunnable)) != null) {
            rootRunnable = tmp;
        }
        return rootRunnable;
    }

    static {
        boolean isSleuthClassExists = false;
        Field delegateField = null;
        try {
            Class.forName("org.springframework.cloud.sleuth.instrument.async.TraceRunnable");
            isSleuthClassExists = true;
            delegateField = ReflectionUtils.findField(TraceRunnable.class, (String)"delegate");
            if (delegateField == null) {
                throw new IllegalStateException("field delegate of class `TraceRunnable` not found");
            }
            delegateField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SLEUTH_CLASS_EXISTS = isSleuthClassExists;
        DELEGATE_FIELD = delegateField;
    }
}

