/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.discovery.EurekaClient;
import com.netflix.loadbalancer.ConfigurationBasedServerList;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;

public class CustomRibbonServerList
implements ServerList<Server>,
IClientConfigAware,
InitializingBean {
    private Logger logger = LoggerFactory.getLogger(CustomRibbonServerList.class);
    private IClientConfig clientConfig;
    private ServerList<? extends Server> delegate;
    @Value(value="${ribbon.eureka.approximateZoneFromHostname:false}")
    private boolean approximateZoneFromHostname = false;
    @Autowired(required=false)
    private Provider<EurekaClient> eurekaClientProvider;

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void afterPropertiesSet() throws Exception {
        String clientName = this.clientConfig.getClientName();
        String listOfServers = (String)this.clientConfig.get(CommonClientConfigKey.ListOfServers);
        if (!StringUtils.isBlank((String)listOfServers)) {
            ConfigurationBasedServerList serverList = new ConfigurationBasedServerList();
            serverList.initWithNiwsConfig(this.clientConfig);
            this.delegate = serverList;
            this.logger.info("\u68c0\u6d4b\u5230{}\u5f3a\u5236\u6307\u5b9a\u8c03\u7528{}", (Object)clientName, (Object)listOfServers);
        } else {
            DomainExtractingServerList serverList;
            DiscoveryEnabledNIWSServerList discoveryServerList = new DiscoveryEnabledNIWSServerList(this.clientConfig, this.eurekaClientProvider);
            this.delegate = serverList = new DomainExtractingServerList((ServerList)discoveryServerList, this.clientConfig, this.approximateZoneFromHostname);
        }
    }

    public List<Server> getInitialListOfServers() {
        return this.delegate.getInitialListOfServers();
    }

    public List<Server> getUpdatedListOfServers() {
        return this.delegate.getUpdatedListOfServers();
    }
}

