/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.com.duibaboot.ext.autoconfigure.data.redis.JedisConnectionFactoryBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.Jedis;

@ConditionalOnClass(value={GenericObjectPool.class, JedisConnection.class, Jedis.class})
public class ExtraRedisTemplateImportBeanDefinitionRegistrar4Jedis
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private List<String> extraRedisTemplateIdsPrefix = new ArrayList<String>();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String extraRedisTemplateIdPrefix;
        String redisConnectionFactoryBeanId;
        Iterator<String> iterator = this.extraRedisTemplateIdsPrefix.iterator();
        while (iterator.hasNext() && !registry.containsBeanDefinition(redisConnectionFactoryBeanId = (extraRedisTemplateIdPrefix = iterator.next()) + "RedisConnectionFactory")) {
            AbstractBeanDefinition extraRedisConnectionFactoryDefinition = BeanDefinitionBuilder.genericBeanDefinition(JedisConnectionFactoryBean.class).setScope("refresh").addConstructorArgValue((Object)extraRedisTemplateIdPrefix).getBeanDefinition();
            BeanDefinitionHolder extraRedisConnectionFactoryDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)extraRedisConnectionFactoryDefinition, redisConnectionFactoryBeanId);
            extraRedisConnectionFactoryDefinitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)extraRedisConnectionFactoryDefinitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)extraRedisConnectionFactoryDefinitionHolder, (BeanDefinitionRegistry)registry);
            String extRedisTemplateBeanName = extraRedisTemplateIdPrefix + "RedisTemplate";
            AbstractBeanDefinition extraRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(RedisTemplate.class).setScope("refresh").addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).addPropertyValue("defaultSerializer", (Object)new Hessian2SerializationRedisSerializer()).getBeanDefinition();
            BeanDefinitionHolder extraRedisTemplateDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)extraRedisTemplateDefinition, extRedisTemplateBeanName);
            extraRedisTemplateDefinitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)extraRedisTemplateDefinitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)extraRedisTemplateDefinitionHolder, (BeanDefinitionRegistry)registry);
            String extStringRedisTemplateBeanName = extraRedisTemplateIdPrefix + "StringRedisTemplate";
            AbstractBeanDefinition extraStringRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(StringRedisTemplate.class).setScope("refresh").addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).getBeanDefinition();
            BeanDefinitionHolder extraStringRedisTemplateDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)extraStringRedisTemplateDefinition, extStringRedisTemplateBeanName);
            extraStringRedisTemplateDefinitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)extraStringRedisTemplateDefinitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)extraStringRedisTemplateDefinitionHolder, (BeanDefinitionRegistry)registry);
        }
    }

    public void setEnvironment(Environment environment) {
        String redisExtraIdPrefix = "duiba.redis.extra.";
        String redisExtraIdSuffix = ".host";
        String redisExtraIdSentinelSuffix = ".sentinel.master";
        String redisExtraIdClusterSuffix = ".cluster.nodes";
        LinkedHashMap props = SpringEnvironmentUtils.getFlatEnvironments((Environment)environment);
        for (Map.Entry entry : props.entrySet()) {
            if (!((String)entry.getKey()).startsWith(redisExtraIdPrefix)) continue;
            int prefixLength = redisExtraIdPrefix.length();
            if (((String)entry.getKey()).endsWith(redisExtraIdSuffix)) {
                this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdSuffix.length()));
                continue;
            }
            if (((String)entry.getKey()).endsWith(redisExtraIdSentinelSuffix)) {
                this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdSentinelSuffix.length()));
                continue;
            }
            if (!((String)entry.getKey()).endsWith(redisExtraIdClusterSuffix)) continue;
            this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdClusterSuffix.length()));
        }
    }
}

