/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ParamComparator;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.CustomizeCallbackFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowReplayUtils {
    private static final Logger log = LoggerFactory.getLogger(FlowReplayUtils.class);
    private static final String DUIBA_FLOW_REPLAY_REPORT_ID = System.getenv("DUIBA_FLOW_REPLAY_REPORT_ID");

    private FlowReplayUtils() {
    }

    public static boolean isJSONValid(String json) {
        if (json == null) {
            return false;
        }
        if (!json.startsWith("{") && !json.startsWith("[")) {
            return false;
        }
        try {
            JSONObject.parseObject((String)json);
        }
        catch (Exception e0) {
            try {
                JSONObject.parseArray((String)json);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isReplayEnv() {
        return StringUtils.isNotBlank((CharSequence)DUIBA_FLOW_REPLAY_REPORT_ID);
    }

    public static boolean isReportIdValid(Long reportId) {
        if (StringUtils.isBlank((CharSequence)DUIBA_FLOW_REPLAY_REPORT_ID)) {
            return false;
        }
        return DUIBA_FLOW_REPLAY_REPORT_ID.equals(String.valueOf(reportId));
    }

    public static String parseApiNameByMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, method.getDeclaringClass());
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        Class<?>[] parametersTypes = method.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    public static boolean isMethodEqual(String spanMethod, Method currentMethod) {
        return spanMethod.equals(currentMethod.getName());
    }

    public static boolean isArgumentsTypesEqual(String[] spanParameterTypes, Class<?>[] currentParameterTypes) {
        for (int i = 0; i < currentParameterTypes.length; ++i) {
            if (currentParameterTypes[i].getName().equals(spanParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static String stringArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return Joiner.on((String)",").join((Object[])stringArray);
    }

    public static String classArrayToString(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>(classArray.length);
        for (Class<?> c : classArray) {
            classNames.add(c.getName());
        }
        return Joiner.on((String)",").join(classNames);
    }

    public static boolean isArgumentsEqual(Object[] spanParameterValues, Object[] currentParameterValues) {
        for (int i = 0; i < currentParameterValues.length; ++i) {
            Object spanArg = spanParameterValues[i];
            Object arg = currentParameterValues[i];
            if (FlowReplayUtils.isObjectEqual(spanArg, arg)) continue;
            return false;
        }
        return true;
    }

    public static Set<StepDiffColumn> compareArray(String traceId, Integer spanIdx, Object[] spanParameterValues, Object[] currentParameterValues) {
        if (StringUtils.isBlank((CharSequence)traceId) || spanIdx == null) {
            return null;
        }
        ParamComparator.CompareResult compareResult = ParamComparator.compareArray(spanParameterValues, currentParameterValues);
        Set<ParamComparator.DiffItem> diffItems = compareResult.getDiffItems();
        HashSet<StepDiffColumn> result = new HashSet<StepDiffColumn>();
        for (ParamComparator.DiffItem it : diffItems) {
            result.add(StepDiffColumn.builder().traceId(traceId).spanIdx(spanIdx).paramIdx(it.getParamIdx()).columnPath(it.getColumnPath()).build());
        }
        return result;
    }

    public static Set<StepDiffColumn> compareObject(String traceId, Integer spanIdx, Object spanParameterValue, Object currentParameterValue) {
        if (StringUtils.isBlank((CharSequence)traceId) || spanIdx == null) {
            return null;
        }
        ParamComparator.CompareResult compareResult = ParamComparator.compareObject(spanParameterValue, currentParameterValue);
        Set<ParamComparator.DiffItem> diffItems = compareResult.getDiffItems();
        HashSet<StepDiffColumn> result = new HashSet<StepDiffColumn>();
        for (ParamComparator.DiffItem it : diffItems) {
            result.add(StepDiffColumn.builder().traceId(traceId).spanIdx(spanIdx).paramIdx(it.getParamIdx()).columnPath(it.getColumnPath()).build());
        }
        return result;
    }

    public static boolean isReturnTypeEqual(String spanReturnType, Class<?> currentReturnType) {
        if (spanReturnType == null && currentReturnType == null) {
            return true;
        }
        if (currentReturnType != null) {
            return currentReturnType.getName().equals(spanReturnType);
        }
        return false;
    }

    public static boolean isTypeFullPathEqual(String spanTypeFullPath, String currentTypeFullPath) {
        return Objects.equals(spanTypeFullPath, currentTypeFullPath);
    }

    public static boolean isGlobalWhitelist(Object[] allArguments) {
        if (allArguments != null) {
            for (Object obj : allArguments) {
                if (obj == null || !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(obj.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isObjectEqual(Object recordVal, Object replayVal) {
        if (recordVal == null && replayVal == null) {
            return true;
        }
        if (recordVal == null || replayVal == null) {
            return false;
        }
        if (FlowReplayUtils.isColumnsTimestamp(recordVal, replayVal)) {
            return true;
        }
        if (replayVal instanceof String && ((String)replayVal).contains("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")) {
            return true;
        }
        if (recordVal instanceof byte[] && replayVal instanceof byte[]) {
            if (((byte[])replayVal).length == 32 && "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(new String((byte[])replayVal))) {
                return true;
            }
            return Objects.deepEquals(recordVal, replayVal);
        }
        if (recordVal instanceof byte[][] && replayVal instanceof byte[][]) {
            byte[][] recordValArray = (byte[][])recordVal;
            byte[][] replayValArray = (byte[][])replayVal;
            if (recordValArray.length != replayValArray.length) {
                return false;
            }
            for (int i = 0; i < replayValArray.length; ++i) {
                byte[] v = replayValArray[i];
                if (v.length == 32 && "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(new String(v)) || Objects.deepEquals(recordValArray[i], v)) continue;
                return false;
            }
            return true;
        }
        String recordJson = JSON.toJSONString((Object)recordVal);
        String replayJson = JSON.toJSONString((Object)replayVal);
        Object recordObj = JSON.parse((String)recordJson);
        Object replayObj = JSON.parse((String)replayJson);
        if (recordObj instanceof JSONArray && replayObj instanceof JSONArray) {
            return FlowReplayUtils.isJSONArrayEqual((JSONArray)recordObj, (JSONArray)replayObj);
        }
        if (recordObj instanceof JSONObject && replayObj instanceof JSONObject) {
            return FlowReplayUtils.isJSONObjectEqual((JSONObject)recordObj, (JSONObject)replayObj);
        }
        return recordObj.equals(replayObj);
    }

    public static boolean isColumnsTimestamp(Object recordValue, Object replayValue) {
        long recordValueLong = 0L;
        if (recordValue instanceof String) {
            try {
                recordValueLong = Long.parseLong((String)recordValue);
            }
            catch (Exception e) {
                return false;
            }
        } else if (recordValue instanceof Long) {
            recordValueLong = (Long)recordValue;
        } else {
            return false;
        }
        long replayValueLong = 0L;
        if (replayValue instanceof String) {
            try {
                replayValueLong = Long.parseLong((String)replayValue);
            }
            catch (Exception e) {
                return false;
            }
        } else if (replayValue instanceof Long) {
            replayValueLong = (Long)replayValue;
        } else {
            return false;
        }
        return FlowReplayUtils.isTimestamp(recordValueLong) && FlowReplayUtils.isTimestamp(replayValueLong);
    }

    private static boolean isTimestamp(long t) {
        long now = System.currentTimeMillis();
        long oneYearMillis = 31536000000L;
        long start = now - 10L * oneYearMillis;
        long end = now + 100L * oneYearMillis;
        return start < t && t < end;
    }

    private static boolean isJSONArrayEqual(JSONArray recordArray, JSONArray replayArray) {
        if (recordArray.size() != replayArray.size()) {
            return false;
        }
        Iterator iterator = recordArray.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object recordValue = iterator.next();
            Object replayValue = replayArray.get(i);
            if (!"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(replayValue) && !FlowReplayUtils.isColumnsTimestamp(recordValue, replayValue)) {
                String recordValueStr = JSON.toJSONString(recordValue);
                if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                    String replayValueStr;
                    String string = replayValueStr = replayValue != null ? JSON.toJSONString((Object)replayValue) : null;
                    if (!FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr))) {
                        return false;
                    }
                } else if (!Objects.equals(recordValue, replayValue)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean isJSONObjectEqual(JSONObject recordObj, JSONObject replayObj) {
        for (Map.Entry entry : recordObj.entrySet()) {
            String replayValueStr;
            if (FlowReplayConstants.COLUMN_NAME_WHITELIST.contains(entry.getKey())) continue;
            Object recordValue = entry.getValue();
            Object replayValue = replayObj.get(entry.getKey());
            if ("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(replayValue) || FlowReplayUtils.isColumnsTimestamp(recordValue, replayValue)) continue;
            String recordValueStr = recordValue != null ? JSON.toJSONString(recordValue) : null;
            String string = replayValueStr = replayValue != null ? JSON.toJSONString((Object)replayValue) : null;
            if (!(FlowReplayUtils.isJSONValid(recordValueStr) ? !FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr)) : !Objects.equals(recordValue, replayValue))) continue;
            return false;
        }
        return true;
    }

    public static String parseApiNameByMethodSignature(MethodSignature methodSignature) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, methodSignature.getDeclaringType());
        sb.append(".");
        sb.append(methodSignature.getMethod().getName());
        sb.append("(");
        Class[] parametersTypes = methodSignature.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    private static void appendTypes(StringBuilder sb, Class<?>[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            FlowReplayUtils.appendType(sb, types[i]);
            if (i >= size - 1) continue;
            sb.append(",");
        }
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type.isArray()) {
            FlowReplayUtils.appendType(sb, type.getComponentType());
            sb.append("[]");
        } else {
            sb.append(type.getSimpleName());
        }
    }

    public static <T> T executeCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        if (StringUtils.isBlank((CharSequence)key)) {
            return callback.invoke();
        }
        if (FlowReplayTrace.isTraced()) {
            return FlowReplayUtils.recordCustomizeCallbackSpan(key, callback);
        }
        if (FlowReplayUtils.isReplayEnv() && ReplayTraceContext.isReplaying()) {
            return FlowReplayUtils.repalyCustomizeCallbackSpan(key, callback);
        }
        return callback.invoke();
    }

    private static <T> T repalyCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        CustomizeCallbackFlowReplaySpan replayDetailSpan = FlowReplayUtils.createReplayDetailSpan(key, span);
        if (span == null || SpanType.CUSTOMIZE != span.getSpanType()) {
            String expert = SpanType.CUSTOMIZE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        CustomizeCallbackFlowReplaySpan customizeCallbackSpan = (CustomizeCallbackFlowReplaySpan)span;
        if (!key.equals(customizeCallbackSpan.getKey())) {
            String expert = customizeCallbackSpan.getKey();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_800, expert, key);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        Object t = customizeCallbackSpan.getReturnValue();
        replayDetailSpan.setRet(t);
        return (T)t;
    }

    private static CustomizeCallbackFlowReplaySpan createReplayDetailSpan(String key, FlowReplaySpan span) {
        CustomizeCallbackFlowReplaySpan replayDetailSpan = CustomizeCallbackFlowReplaySpan.createSpan(key, null);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T recordCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        if (IgnoreSubInvokesContext.isMarked()) {
            return callback.invoke();
        }
        IgnoreSubInvokesContext.keyMark(key);
        T ret = callback.invoke();
        try {
            CustomizeCallbackFlowReplaySpan span = CustomizeCallbackFlowReplaySpan.createSpan(key, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("CustomizeCallback_\u5f55\u5236\u5f02\u5e38", t);
            FlowReplayTrace.remove();
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    public static interface Callback<R> {
        public R invoke() throws Throwable;
    }
}

