/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class PercentageBasedRecordSampler
implements RecordSampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private volatile BitSet sampleDecisions;
    private volatile float percentage;
    private static final int WARMUP_TIMESECONDS = 60;
    private volatile Long recordStartTime;
    private volatile int scale;

    public PercentageBasedRecordSampler() {
        this.init(null, null);
    }

    public void init(Float percentage, Long recordStartTime) {
        this.percentage = percentage != null ? percentage.floatValue() : 0.01f;
        this.recordStartTime = recordStartTime != null ? recordStartTime : System.currentTimeMillis();
        this.scale = 1;
        float currentPercentage = this.percentage * (float)this.scale / 10.0f;
        int outOf100000 = (int)(currentPercentage * 100000.0f);
        this.sampleDecisions = PercentageBasedRecordSampler.randomBitSet(100000, outOf100000, new Random());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warmup() {
        if (this.scale == 10) {
            return;
        }
        int secondsAfterRecordStartTime = (int)((System.currentTimeMillis() - this.recordStartTime) / 1000L);
        int newScale = 10 * secondsAfterRecordStartTime / 60 + 1;
        int n = newScale < 1 ? 1 : (newScale = newScale > 10 ? 10 : newScale);
        if (newScale > this.scale) {
            PercentageBasedRecordSampler percentageBasedRecordSampler = this;
            synchronized (percentageBasedRecordSampler) {
                if (newScale > this.scale) {
                    this.scale = newScale;
                    float currentPercentage = this.percentage * (float)this.scale / 10.0f;
                    int outOf100000 = (int)(currentPercentage * 100000.0f);
                    this.sampleDecisions = PercentageBasedRecordSampler.randomBitSet(100000, outOf100000, new Random());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSampled() {
        if (this.percentage == 0.0f) {
            return false;
        }
        if (this.percentage == 1.0f && this.scale == 10) {
            return true;
        }
        if (this.scale < 10) {
            this.warmup();
        }
        PercentageBasedRecordSampler percentageBasedRecordSampler = this;
        synchronized (percentageBasedRecordSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 99999) {
                this.counter.set(0);
            }
            return result;
        }
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

