/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorRunnable;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileRunnable
extends MonitorRunnable {
    private static final Logger logger = LoggerFactory.getLogger(ProfileRunnable.class);
    private String threadPoolName = "undefined";

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(runnable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public void run() {
        DBTimeProfile.start();
        Runnable runnable = this.getRootRunnable();
        String rootRunnableClassName = runnable.getClass().getName();
        try {
            CatUtils.executeInCatTransaction(() -> {
                super.run();
                return null;
            }, "ThreadPool", "(" + this.threadPoolName + ")" + rootRunnableClassName);
        }
        catch (Throwable throwable) {
            if (this.nestOverLimit(throwable)) {
                throw new RuntimeException("abnormal throwable: \u3010" + throwable.getClass().getName() + "\u3011, stacktrace: \u3010" + ExceptionUtils.getStackTrace((Throwable)throwable) + "\u3011");
            }
            logger.error("", throwable);
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            DBTimeProfile.end((String)(rootRunnableClassName + ", thread:" + Thread.currentThread().getName()));
        }
    }

    private boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", (Object)t.getClass().getName(), (Object)t.getMessage());
                return true;
            }
            t = t.getCause();
            ++nestTime;
        }
        return false;
    }
}

