package cn.com.duibaboot.ext.autoconfigure.batch;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;

/**
 * 请求封装
 */
public class ReqContext {

    public static final String PREF_TEST = "PrefTest";

    public static final int WAITING = 0; //等待处理

    public static final int RUNNING = 1; //运行中

    public static final int NOTIFY = 2; //已通知

    /**
     * 时间搓
     */
    private long timestamp;

    /**
     * 请求参数
     */
    private Object[] params;

    /**
     * 请求的返回值
     */
    private volatile Object result;

    /**
     * 状态
     */
    private volatile int state;

    /**
     * 要调用的目标对象
     */
    private Object target;

    /**
     * 请求方法上的注解信息，超时，是否异步等
     */
    private MergeRequest annotation;

    /**
     * 目标方法全名，包含包路径
     */
    private String fullMethodName;

    /**
     * --------perfTest 相关参数-----------------------
     */
    private boolean currentInPerfTestMode;
    private String currentPerfTestSceneId;
    private boolean testCluster;

    public ReqContext(Object[] params, Object target, MergeRequest annotation) {
        this.timestamp = System.currentTimeMillis();
        this.params = params;
        this.target = target;
        this.annotation = annotation;
        this.fullMethodName = target.getClass().getName() + "." + annotation.method();
        this.currentInPerfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        this.currentPerfTestSceneId = InternalPerfTestContext.getCurrentSceneId();
        this.testCluster = InternalPerfTestContext.isTestCluster();
    }

    public Object[] getParams() {
        return params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public Object getResult() throws Throwable {
        if (result != null && result instanceof Throwable) {
            throw (Throwable) result;
        }
        return result;
    }

    public Object getVolatileResult(){
        return result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getTarget() {
        return target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public MergeRequest getAnnotation() {
        return annotation;
    }

    public void setAnnotation(MergeRequest annotation) {
        this.annotation = annotation;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state >= this.state ? state : this.state;
    }

    public String getFullMethodName() {
        return fullMethodName;
    }

    public boolean isCurrentInPerfTestMode() {
        return currentInPerfTestMode;
    }

    public String getCurrentPerfTestSceneId() {
        return currentPerfTestSceneId;
    }

    public boolean isTestCluster() {
        return testCluster;
    }
}
