package cn.com.duibaboot.ext.autoconfigure.data.redis;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisConnectionFactoryBean implements FactoryBean<JedisConnectionFactory> {

	@Resource
	private RedisProperties redisProperties;
	@Resource
	ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration;
	@Resource
	ObjectProvider<RedisClusterConfiguration> clusterConfiguration;
	@Resource
	ObjectProvider<List<JedisClientConfigurationBuilderCustomizer>> builderCustomizers;

	private String extraRedisTemplateIdPrefix;

	private JedisConnectionFactory jedisConnectionFactory;

	public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
		this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
	}

	private RedisProperties getRedisProperties() {
		if(extraRedisTemplateIdPrefix == null) {
			return redisProperties;
		}else{
			return redisProperties.getExtra().get(extraRedisTemplateIdPrefix);
		}
	}

	@PostConstruct
	public void init() {
		JedisConnectionConfiguration fc = new JedisConnectionConfiguration(getRedisProperties(), sentinelConfiguration, clusterConfiguration, builderCustomizers);
		JedisConnectionFactory f = fc.redisConnectionFactory();
		f.afterPropertiesSet();
		jedisConnectionFactory = f;
	}

	@Override
	public JedisConnectionFactory getObject() throws Exception {
		return jedisConnectionFactory;
	}

	@Override
	public Class<?> getObjectType() {
		return JedisConnectionFactory.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

	public void destroy() {
		if (jedisConnectionFactory != null) {
			jedisConnectionFactory.destroy();
		}
	}
}
