package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * 数据库加密 - 加密规则配置
 * Created by gyf .
 * 2020/8/4 .
 */
@Getter
@Setter
public final class DBEncryptPolicy {

    /**
     * 数据源配置，比如: middleware,gateway* (多个英文","隔开)
     * duiba.db.encrypt.policy.${policyName}.datasources=middleware
     */
    private List<String> datasources;

    /**
     * 数据库表相关配置
     * duiba.db.encrypt.policy.${policyName}.tables.${tableName}.columns.${columnName}.plainColumn=st_name
     * duiba.db.encrypt.policy.${policyName}.tables.${tableName}.columns.${columnName}.cipherColumn=st_name_encr
     * duiba.db.encrypt.policy.${policyName}.tables.${tableName}.columns.${columnName}.assistedQueryColumn=
     * duiba.db.encrypt.policy.${policyName}.tables.${tableName}.columns.${columnName}.encryptor=${encryptorName}
     */
    private Map<String, DBEncryptTableRule> tables;

    /**
     * 其他相关属性配置(针对单个policy的配置)
     * 比如:
     * duiba.db.encrypt.policy.${policyName}.props.query.with.cipher.column=false
     * duiba.db.encrypt.policy.${policyName}.props.sql.show=true
     */
    private Properties props = new Properties();
}
