package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import com.alibaba.fastjson.JSON;
import com.google.gson.JsonElement;

/**
 * Created by guoyanfei .
 * 2019-09-25 .
 */
public abstract class StandardSpan extends FlowReplaySpan {

    private static final long serialVersionUID = -8301197111272314858L;

    /**
     * 方法名称
     */
    private String methodName;

    /**
     * 参数类型数组
     */
    private String[] parameterTypes;

    /**
     * 参数值数组
     */
    private byte[] parameterValues;

    /**
     * 参数值数组的jsonArray
     */
    private Object parameterValuesJson;

    /**
     * 返回值类型
     */
    private String returnType;

    /**
     * 返回值
     */
    private byte[] returnValue;

    /**
     * 返回值的json值
     */
    private Object returnValueJson;

    @Override
    public void convertToDetail(String stackFrames) {
        super.convertToDetail(stackFrames);

        try {
            JsonElement pTemp = gson.toJsonTree(this.getParameterValues());
            this.parameterValuesJson = JSON.parse(pTemp.toString());
        } catch (Exception e) {
            this.parameterValuesJson = e.toString();
        }

        try {
            JsonElement rTemp = gson.toJsonTree(this.getReturnValue());
            this.returnValueJson = JSON.parse(rTemp.toString());
        } catch (Exception e) {
            this.returnValueJson = e.toString();
        }

        this.parameterValues = null;
        this.returnValue = null;
    }

    public String getMethodName() {
        return methodName;
    }

    public String[] getParameterTypes() {
        return parameterTypes;
    }

    public Object getParameterValuesJson() {
        return parameterValuesJson;
    }

    public Object getReturnValueJson() {
        return returnValueJson;
    }

    public Object[] getParameterValues() {
        return (Object[]) KryoSerializer.deserialize(parameterValues);
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }

    public String getReturnType() {
        return returnType;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setParameterValues(Object[] parameterValues) {
        this.parameterValues = KryoSerializer.serialize(parameterValues);
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setReturnValue(Object ret) {
        this.returnValue = KryoSerializer.serialize(ret);
    }

}
