package cn.com.duibaboot.ext.autoconfigure.gclog;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.*;

/**
 * 下载gclog的端点
 * Created by guoyanfei .
 */
@Endpoint(id="gclog-download")
public class GclogDownloadMvcEndpoint {

    /**
     * 返回gclog的文件流
     * @param path
     * @return
     * @throws IOException
     */
    @ReadOperation
    public Resource gclogDownload(@RequestParam String path) {
        if (!path.startsWith(GclogEndpoint.GCLOG_PATH)) {
            throw new UnsupportedOperationException("不支持的操作");
        }
        String pathFileName = path.substring(GclogEndpoint.GCLOG_PATH.length() + 1);
        if (pathFileName.contains("/") || pathFileName.contains("\\")) {
            throw new UnsupportedOperationException("不支持的操作");
        }

        File file = new File(path);

        return new FileSystemResource(file);
    }

//    @RequestMapping(method = RequestMethod.GET)
//    public void invoke(@RequestParam String path, HttpServletResponse response) throws IOException {
//        if (!path.startsWith(GclogEndpoint.GCLOG_PATH)) {
//            throw new UnsupportedOperationException("不支持的操作");
//        }
//        File file = new File(path);
//
//        response.setContentType("application/octet-stream;charset=UTF-8");
//        response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
//        response.setContentLength((int) file.length());
//
//        byte[] buffer = new byte[4096];
//        try(
//            BufferedOutputStream output = new BufferedOutputStream(response.getOutputStream());
//            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file))
//        ) {
//            int n = -1;
//            while ((n = input.read(buffer, 0, 4096)) > -1) {
//                output.write(buffer, 0, n);
//            }
//            output.flush();
//            response.flushBuffer();
//        }
//    }

}
