package cn.com.duibaboot.ext.autoconfigure.ons;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.google.common.base.Throwables;

/**
 * OnsMessageListener的包装，增加cat监控
 */
public class OnsMessageListenerWrapper implements MessageListener {

    private MessageListener source;

    public OnsMessageListenerWrapper(MessageListener source){
        this.source = source;
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        DBTimeProfile.start();
        try {
            return CatUtils.executeInCatTransaction(() -> source.consume(message, context),
                    "MessageQueue", "ons.consume");
        } catch(Throwable e) {
            throw Throwables.propagate(e);
        } finally {
            DBTimeProfile.end("ons.consume");
        }
    }
}
