/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.com.duibaboot.ext.autoconfigure.data.redis.DuibaRedisCondition;
import cn.com.duibaboot.ext.autoconfigure.data.redis.Hessian2RedisDeserializeMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.data.redis.JedisConnectionConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.LettuceConnectionConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class})
@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@Import(value={LettuceConnectionConfiguration.class, JedisConnectionConfiguration.class})
public class RedisAutoConfiguration {
    @Bean
    public Hessian2RedisDeserializeMvcEndpoint hessian2RedisDeserializeMvcEndpoint() {
        return new Hessian2RedisDeserializeMvcEndpoint();
    }

    @Configuration
    @ConditionalOnClass(value={RedisOperations.class})
    @Conditional(value={DuibaRedisCondition.class})
    protected static class RedisConfiguration {
        protected RedisConfiguration() {
        }

        @RefreshScope
        @Bean(name={"redisTemplate"})
        @ConditionalOnMissingBean(name={"redisTemplate"})
        public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            template.setDefaultSerializer((RedisSerializer)new Hessian2SerializationRedisSerializer());
            return template;
        }

        @RefreshScope
        @Bean(name={"stringRedisTemplate"})
        @ConditionalOnMissingBean(name={"stringRedisTemplate"})
        public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }
    }
}

