/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayMockSupport;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import com.alibaba.fastjson.JSONObject;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ReplayContextHolder {
    private static final List<String> DEFAULT_HOST_WHITELIST = Arrays.asList("127.0.0.1", "localhost");
    private static volatile boolean replaying = false;
    private static volatile ReplayContext replayContext;
    private static volatile List<String> ipWhitelist;
    private static volatile long mockSysTime;
    private static volatile long recordStartTime;
    private static volatile JSONObject debugInfo;
    private static volatile List<String> maskedApis;
    private static volatile List<String> maskedTraceIds;
    private static volatile Map<String, Set<StepDiffColumn>> maskedStepDiffColumnMap;

    private ReplayContextHolder() {
    }

    public static boolean isReplaying() {
        return replaying && replayContext != null;
    }

    public static synchronized void start(ReplayConfigDto replayConfig) {
        if (replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u5f00\u59cb_\u8bf7\u52ff\u91cd\u590d\u5f00\u59cb");
        }
        CatInstance.disable();
        replaying = true;
        replayContext = new ReplayContext(replayConfig);
        ipWhitelist = replayConfig.getIpWhitelist();
        ipWhitelist.addAll(DEFAULT_HOST_WHITELIST);
        maskedApis = replayConfig.getMaskedApis();
        maskedTraceIds = replayConfig.getMaskedTraceIds();
        maskedStepDiffColumnMap = replayConfig.getMaskedStepDiffColumnMap();
        replayContext.start();
        recordStartTime = replayConfig.getStartTime();
        mockSysTime = replayConfig.getStartTime();
        ReplayMockSupport.setOffsetMillis(mockSysTime - replayContext.getStartTime());
        debugInfo = new JSONObject();
        debugInfo.put("mockSysTime", (Object)DateUtils.getSecondStr((long)System.currentTimeMillis()));
        debugInfo.put("jvmArgs", ManagementFactory.getRuntimeMXBean().getInputArguments());
        FlowReplayFileComponent.initDir();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayStartEvent());
    }

    public static String debugInfo() {
        if (debugInfo != null) {
            return debugInfo.toJSONString();
        }
        return null;
    }

    public static boolean canHostPass(String host) {
        if (CollectionUtils.isEmpty(ipWhitelist)) {
            return true;
        }
        return ipWhitelist.contains(host);
    }

    public static boolean isMaskedApi(String apiName) {
        List<String> maskedApisTemp = maskedApis;
        if (CollectionUtils.isEmpty(maskedApisTemp)) {
            return false;
        }
        return maskedApisTemp.contains(apiName);
    }

    public static boolean isMaskedTraceIds(String traceId) {
        List<String> maskedTraceIdsTemp = maskedTraceIds;
        if (CollectionUtils.isEmpty(maskedTraceIdsTemp)) {
            return false;
        }
        return maskedTraceIdsTemp.contains(traceId);
    }

    public static boolean isMaskedStepDiffColumn(StepDiffColumn currentDiffColumn) {
        Map<String, Set<StepDiffColumn>> maskedStepDiffColumnMapTemp = maskedStepDiffColumnMap;
        if (maskedStepDiffColumnMapTemp == null || maskedStepDiffColumnMapTemp.isEmpty()) {
            return false;
        }
        Set<StepDiffColumn> maskedStepDiffColumns = maskedStepDiffColumnMapTemp.get(currentDiffColumn.getTraceId());
        return maskedStepDiffColumns.contains(currentDiffColumn);
    }

    public static long calculateTraceTimestamp(short secondsAfterStart) {
        return recordStartTime + (long)(secondsAfterStart * 1000);
    }

    public static boolean isMockSysTimeValid(long traceTimestamp) {
        return traceTimestamp - mockSysTime < 60000L;
    }

    public static synchronized void setMockSysTime(long traceTimestamp) {
        if (ReplayContextHolder.isMockSysTimeValid(traceTimestamp)) {
            return;
        }
        mockSysTime = traceTimestamp;
        ReplayMockSupport.setOffsetMillis(mockSysTime - replayContext.getStartTime());
    }

    public static synchronized void end() {
        if (!replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u7ed3\u675f_\u8bf7\u52ff\u91cd\u590d\u7ed3\u675f");
        }
        replaying = false;
        ReplayMockSupport.setOffsetMillis(0L);
        replayContext.end();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayEndEvent());
    }

    public static void forceEnd() {
        replayContext.tracesLoadFinish();
        replayContext.replayersDone();
        ReplayContextHolder.end();
    }

    public static ReplayContext getReplayContext() {
        return replayContext;
    }
}

