/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.actuate;

import cn.com.duibaboot.ext.autoconfigure.actuate.CustomMvcEndpointSecurityInterceptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.ControllerEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.DispatcherServlet;

@ManagementContextConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@EnableConfigurationProperties(value={WebEndpointProperties.class})
public class SecurityEndpointWebMvcManagementContextConfiguration {
    @Bean
    public static BeanPostProcessor endpointHandlerMappingPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcEndpointHandlerMapping) {
                    WebMvcEndpointHandlerMapping m = (WebMvcEndpointHandlerMapping)bean;
                    CustomMvcEndpointSecurityInterceptor customMvcEndpointSecurityInterceptor = new CustomMvcEndpointSecurityInterceptor();
                    m.setInterceptors(new Object[]{customMvcEndpointSecurityInterceptor});
                    Field f = ReflectionUtils.findField(m.getClass(), (String)"adaptedInterceptors");
                    f.setAccessible(true);
                    List adaptedInterceptors = (List)ReflectionUtils.getField((Field)f, (Object)bean);
                    adaptedInterceptors.add(customMvcEndpointSecurityInterceptor);
                } else if (bean instanceof ControllerEndpointHandlerMapping) {
                    ControllerEndpointHandlerMapping m = (ControllerEndpointHandlerMapping)bean;
                    CustomMvcEndpointSecurityInterceptor customMvcEndpointSecurityInterceptor = new CustomMvcEndpointSecurityInterceptor();
                    m.setInterceptors(new Object[]{customMvcEndpointSecurityInterceptor});
                    Field f = ReflectionUtils.findField(m.getClass(), (String)"adaptedInterceptors");
                    f.setAccessible(true);
                    List adaptedInterceptors = (List)ReflectionUtils.getField((Field)f, (Object)bean);
                    adaptedInterceptors.add(customMvcEndpointSecurityInterceptor);
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }

    @Bean
    public Filter servletEndpointSecurityfilter(ServletEndpointsSupplier servletEndpointsSupplier, WebEndpointProperties properties) {
        ArrayList<String> pathes = new ArrayList<String>();
        String basePath = StringUtils.trimToEmpty((String)properties.getBasePath());
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        for (ExposableEndpoint endpoint : servletEndpointsSupplier.getEndpoints()) {
            if (endpoint instanceof ExposableWebEndpoint) {
                for (WebOperation operation : ((ExposableWebEndpoint)endpoint).getOperations()) {
                    pathes.add(basePath + operation.getRequestPredicate().getPath());
                }
                continue;
            }
            if (!(endpoint instanceof PathMappedEndpoint)) continue;
            pathes.add(basePath + ((PathMappedEndpoint)endpoint).getRootPath());
        }
        return new ServletEndpointSecurityfilter(pathes);
    }

    static class ServletEndpointSecurityfilter
    implements Filter {
        private List<String> pathes;

        public ServletEndpointSecurityfilter(List<String> pathes) {
            this.pathes = pathes;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            for (String path : this.pathes) {
                boolean canContinue;
                if (!req.getRequestURI().startsWith(path) || (canContinue = CustomMvcEndpointSecurityInterceptor.canContinue(req, resp))) continue;
                return;
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

